set noderank [parallel noderank]
puts "starting: noderank is $noderank"
set localList ""

proc showTime {commentString} {
  set tsec [clock seconds]
  set tms [clock clicks -milliseconds]
  set ts [clock format $tsec -format %c]
  puts "$commentString Time= $ts   tsec= $tsec tms= $tms"
}


proc writeCombineGathered {filename dataNameVals dataValArrayNum numFrames glist}  {
  #normally, only node 0 should run this
  global dataValArray
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  showTime "Starting writeCombineGathered\n noderank= $noderank  nodecount= $nodecount"
 
  set dataName(vals) $dataNameVals 
  set currentMol 0





  variable numDataFrames  $numFrames
  set usesFreeSelection 0
  set dataFileVersion "1.4"
  
  set writeDataFile [open $filename w]
  puts $writeDataFile "# VMD Timeline data file"
  puts $writeDataFile "# CREATOR= $::tcl_platform(user)"
  puts $writeDataFile "# MOL_NAME= [molinfo $currentMol get name]"
  puts $writeDataFile "# DATA_TITLE= $dataName(vals)"
  puts $writeDataFile "# FILE_VERSION= $dataFileVersion"
  puts $writeDataFile "# NUM_FRAMES= $numFrames "
  puts $writeDataFile "# NUM_ITEMS= $dataValArrayNum"

  if {$usesFreeSelection} {
    puts $writeDataFile "# FREE_SELECTION= 1"
    puts $writeDataFile "#"
    # XXX does not handle free selection yet
  } else {
    puts $writeDataFile "# FREE_SELECTION= 0"
    puts $writeDataFile "#"

    set frame -1
    set listNoderank 0
    puts "about to loop over glist"
    foreach nodeElem $glist {
      puts  "Node loop start: listNoderank= $listNoderank\n"
      set lengthNodeElem [llength $nodeElem]
      puts "length of nodeElem is $lengthNodeElem"
      foreach frameElem $nodeElem {
        #puts "write phase, frameElem= >$frameElem<"
        set i 0
        foreach val $frameElem {
          if {$i == 0} {
            set frame $val
            #puts "output, frame is $frame, frameElem= >$frameElem<"
          } else {
            # the index in list is one greater than dataValArray index 
            set dvIndex [expr $i -1]
            # write out to file
            set resid $dataValArray(resid,$dvIndex)
            set chain $dataValArray(chain,$dvIndex)
            set segname $dataValArray(segname,$dvIndex)
            puts $writeDataFile "$resid $chain $segname $frame $val"
          }
          incr i
        }
      }
      #only diagnostic
      incr listNoderank
    }     
  } 
  close $writeDataFile

  showTime "Finishing writeCombineGathered\n Node $noderank  nodecount= $nodecount"
  return
}

 



proc makeSels {currentMol partSelText keyAtomSelString} {
  #make selections and put them into dataValArray
  #also, put description data about each selection (resid, etc.) into dataValArray
  global dataValArray
  global dataValSelList
     #a flat list with the same information as dataValArray(sel,-- )

  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  showTime "*** Starting makeSels  Node $noderank"
  set theSel [atomselect $currentMol "$partSelText and $keyAtomSelString"]

  set alist [$theSel get index]
  set alistLength [llength $alist]
  showTime "Node $noderank alistLength= $alistLength"
  #set frameTotal [expr  ($lastAnalysisFrame - $firstAnalysisFrame +1)]
 
  set i 0
  foreach a $alist {
    set aSel [atomselect $currentMol "index $a"]
    
    set com "atomselect $currentMol \"same residue as index $a\"" 
    # make this in global namespace.  Pollution, but works.
    set dataValArray(sel,$i) [namespace eval :: $com]



    ## for the future freeSel version, set selecton text and display text here
    set dataValArray(resid,$i) [$aSel  get resid]
    set dataValArray(chain,$i) [$aSel  get chain]
    set dataValArray(segname,$i) [$aSel  get segname]

    $aSel delete
    incr i
  }
 #this returns dataValArrayNum 
  set dataValArrayNum $i
  set dataValSelList ""
  showTime "Node $noderank, before create dataValSelList"
  for {set dataValIndex 0}  {$dataValIndex < $dataValArrayNum} {incr dataValIndex} {
    lappend dataValSelList $dataValArray(sel,$dataValIndex)
  }
  # the seletion command name list is stored in two places, since we needed a new way to present to measure sasalilst 
  showTime "Node $noderank, Done with selections. alistLength= $alistLength dataValArrayNum= $i"
 
  return $dataValArrayNum
}

proc mpiSASAFrame { balancerank userdata} {
  global localList
  global dataValArray 
  global dataValSelList

  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  showTime "starting mpiSASAFrame, Node $noderank"

  puts "Node $noderank, before testing length of localList"
  set testLength [llength $localList]
  puts "Node $noderank, testLength= $testLength  is length of localList"

  #read userdata
  set numFrames [lindex $userdata 0] 
   #not using numFrames yet, maybe for tiled vesions
  set dataValArrayNum [lindex $userdata 1] 

  set trajectoryFilename [lindex $userdata 2]

  set balancecount [lindex $userdata 3]

  puts "reading from userdata; trajectoryFilename is $trajectoryFilename, Node $noderank, balancerank= $balancerank"
  #delete loaded frames
  animate delete  beg 0 end -1 skip 0 0
  puts "Node $noderank,  frames deleted" 
  set start [expr round($balancerank     * $numFrames / $balancecount)]
  set end   [expr round(($balancerank + 1 ) * $numFrames / $balancecount) - 1]
  puts "start= $start  end= $end, Node $noderank, balancerank= $balancerank"

  puts "Node $noderank, about to add frames"
  mol addfile $trajectoryFilename first $start last $end step 1 waitfor all
  puts "Node $noderank, done adding frames"
  puts "Node $noderank, balance $balancerank, numframes is [molinfo 0 get numframes]" 
  #all but currentMol should be passed in.


  #set firstAnalysisFrame 0
  #set lastAnalysisFrame $numFrames 

  showTime "In mpiSASAFrame, Node $noderank, dataValArrayNum= $dataValArrayNum."
  #showTime "Node $noderank, before file add"
  puts "done with showtime, Node $noderank"

 
  #puts "Node $noderank, already have loaded [molinfo top get numframes] frames"

  
 puts "starting loop, Node $noderank, balancerank= $balancerank, start=$start, end=$end"
  #make a simple list of the selections, could do this once per job, but is quick

  showTime "Node $noderank, before loop over frames"
  puts "Node $noderank, before dataVal print line"
 

  for {set theFrame $start} {$theFrame <= $end} {incr theFrame} {
    set loadedFrame [expr $theFrame - $start ]  
    
    for {set dataValIndex 0}  {$dataValIndex < $dataValArrayNum} {incr dataValIndex} {

      #showTime "Node $noderank, before frame change, dataValIndex $dataValIndex"   
      $dataValArray(sel,$dataValIndex) frame $loadedFrame
      #showTime "Node $noderank, before calc, dataValIndex $dataValIndex"   
    }  
    showTime "Node $noderank, before sasalist call, theFrame= $theFrame loadedFrame= $loadedFrame"   
    set sasaValList [measure sasalist 1.4 $dataValSelList -samples 500] 
    showTime "Node $noderank, before lappend sasalist to flist, theFrame= $theFrame loadedFrame= $loadedFrame"   
    set flist "$theFrame ${sasaValList}"  

    set lengthFlist [llength $flist]
    showTime "Node $noderank, before localList lappend, lengthFlist= $lengthFlist, theFrame= $theFrame loadedFrame= $loadedFrame"   
    lappend localList $flist


    ## debug printing
    ##puts "Node $noderank;  flist: $flist"
    ##puts "Node $noderank;   locallist: $localList"

    #report length of localList
    set theLength [llength $localList]
    showTime "Length of localList is $theLength, Node $noderank. "
  }
}


proc parSASAcalc {psfFilename dcdFilename numFrames runsPerNode outFilename} {
  global localList
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  set start 0
  set end [expr $numFrames - 1]

  puts "starting parSASAcalc"
  #XX note that we are not setting start and end frames
  showTime "parSASAcalc, Node $noderank, before file add"
  mol new $psfFilename first 0 last 0 step 1  waitfor all
  #load only 1 frame to do selections with
  #do modulo file reading here if needed

  showTime "Node $noderank, before traj load"

  set trajectoryFilename $dcdFilename
  #mol addfile $trajectoryFilename first $start last $end step 1 waitfor all

  puts "Node $noderank, loaded [molinfo top get numframes] frames"
 
  # Make work - create apprporiately-sized pieces of work for load balanced run.
  # Here we enumerate frames (later, tiles of residues-or-selections x frames)
  # to analyze  and divide up potential tasks.  Could be work blocks.
  # 
  set currentMol 0
  set partSelText "all"
  set keyAtomSelString "((all and name CA) or ( (not protein) and  ( (name \"C3\\'\") or (name \"C3\\*\") ) ) or (name BAS) )"

  # make the selections and find description data 
  set dataValArrayNum [makeSels $currentMol $partSelText $keyAtomSelString]

  puts "writing to userdata; trajectoryFilename is $trajectoryFilename"

  set balancecount [expr $nodecount * $runsPerNode]
  set userdata [list $numFrames $dataValArrayNum $trajectoryFilename $balancecount] 

  if {$balancecount > $numFrames} {
    set balancecount $numFrames
  }

  puts "** balancecount is $balancecount"
  showTime "Now for parallel for, numFrames = $numFrames, balancecount= $balancecount"

  parallel for 0 [expr $balancecount - 1] mpiSASAFrame $userdata 

  showTime "After parallel for Node $noderank"

  parallel barrier
  showTime "After parallel barrier, Node $noderank"
  
  set gatherList [parallel allgather $::localList]
  showTime "After parallel allgather, Node $noderank "
  if {$noderank == 0 } {
    ##puts "Node $noderank gatherList= $gatherList"
  }
  # only print messages on node 0
  set thePid [pid]
  set valFileName "sasa"
  set labelText "SASA (A^2)"
  if {$noderank == 0} {
   puts "before writeCombineGathered call: outFilename= $outFilename labelText= $labelText"
    writeCombineGathered $outFilename $labelText $dataValArrayNum $numFrames $gatherList
  }

}







