#!/bin/sh

# Mime Installer for RealPlayer8
# (C) 1999 RealNetworks, Inc.

# The purpose of this shell script is to automate the installation of 
# RealNetworks mimetypes for Netscape, Gnome, and KDE.  

# args
# 1 mime type
# 2 dest dir
# 3 mimetypes (space sep)
# 4 mime.types location

if [ ! -f realplay ] ;  then
    echo "This shell script should only be run from the installed location of the"
    echo "RealPlayer.  Please cd to that directory and try again"
    exit
fi

installmime ()
{
    kdeappdest=$5
    gnomedest=$6
    gnomeappdest=$7
    mkdir -p $2
 
    filename=/tmp/`echo $1 | sed 's/\\//:/g'`.kdelnk
    kdestyleexts=`echo $3 | sed 's/\([a-z0-9A-Z][a-z0-9A-Z]*\)/*.\1;/g' | sed 's/ //g'`
	if [ ! -f $filename ] ; 
    then 
	cat mime.kdelnk | sed s:__MIME__:$1:g |  \
                    sed s:__EXT__:$kdestyleexts:g > $filename
    fi
    mkdir -p `dirname $2/$1`
    cat $filename | sed s:__LOCATION__:`pwd`:g > $2/$1.kdelnk
    rm $filename
    filesmodified=$2/$1.kdelnk

    if [ -f $kdeappdest/RealPlayer.kdelnk ] ; 
    then
       exts="`grep MimeType $kdeappdest/RealPlayer.kdelnk`$1;"
       grep -v MimeType $kdeappdest/RealPlayer.kdelnk > /tmp/$$ && cp /tmp/$$ $kdeappdest/RealPlayer.kdelnk && rm -f /tmp/$$
       echo $exts >> $kdeappdest/RealPlayer.kdelnk
       filesmodified="$filesmodified $kdeappdest/RealPlayer.kdelnk"
    fi
       
    mkdir -p $GNOMEDEST
    printf "$1\n" >> $GNOMEDEST/realplay.keys
 # how come gnome doesn't let you do absolute paths?
    printf "\topen=realplay %%f &\n" >> $GNOMEDEST/realplay.keys
    printf "\tview=realplay %%f &\n" >> $GNOMEDEST/realplay.keys
    printf "\ticon-filename=`pwd`/rp7doc.png\n" >> $GNOMEDEST/realplay.keys
    filesmodified="$filesmodified $GNOMEDEST/realplay.keys"

    mkdir -p $GNOMEDEST
    printf "$1\n" >> $GNOMEDEST/realplay.mime
    printf "\text: $3\n" >> $GNOMEDEST/realplay.mime
    filesmodified="$filesmodified $GNOMEDEST/realplay.mime"

    if [ $4 = "local" ] ;
    then 
        mimetypesdests="$HOME/.mime.types"
        mailcapdests="$HOME/.mailcap"
    else
        mimetypesdests="/etc/mime.types /usr/local/lib/netscape/mime.types"
        mailcapdests="/etc/mailcap /usr/local/lib/netscape/mailcap"
    fi
   
    for mimetypesdest in $mimetypesdests ; do
            if [ ! -d `dirname $mimetypesdest` ] ; then 
		    mkdir -p `dirname $mimetypesdest`
            fi
            if [ -f $mimetypesdest ] ; then
		    grep -v $1 $mimetypesdest > /tmp/$$ && cp /tmp/$$ $mimetypesdest && rm -f /tmp/$$
            fi
	    echo "$1 $3" >> $mimetypesdest
	    filesmodified="$filesmodified $mimetypesdest"
    done

    for mailcapdest in $mailcapdests ; do
            if [ ! -d `dirname $mailcapdest` ] ; then 
		    mkdir -p `dirname $mailcapdest`
            fi
            if [ -f $mailcapdest ] ; then
		    grep -v $1 $mailcapdest > /tmp/$$ && cp /tmp/$$ $mailcapdest && rm -f /tmp/$$
	    fi
	    echo "$1;`pwd`/realplay \"%u\"" >> $mailcapdest
	    filesmodified="$filesmodified $mailcapdest"
    done

    first=0
    mime="$1"
    for file in $filesmodified ; do  printf "%-30s%-50s\n" "$mime" $file ; if  [ $first = 0 ] ; then first=1; mime=""; fi  ; done
}

abort () 
{
    echo "Error - mimeinstall.sh: $1"
    exit 1
}

REALPLAY=`pwd`/realplay
LOC=`pwd`

if [ "$2" = "global" ];
then 
    STDDEST=global
    KDEDEST=/usr/share/mimelnk/
    KDEAPPDEST=/usr/share/applnk/Multimedia
    GNOMEDEST=/usr/share//mime-info/
    rm -f $GNOMEDEST/realplay.keys
    rm -f $GNOMEDEST/realplay.mime
    GNOMEAPPDEST=/usr/share/apps/Multimedia
    rm -f $GNOMEAPPDEST/realplayer.desktop
else
    STDDEST=local
    KDEDEST=$HOME/.kde/share/mimelnk/
    KDEAPPDEST=$HOME/.kde/share/applnk/Multimedia
    GNOMEDEST=$HOME/.gnome/mime-info/
    rm -f $GNOMEDEST/realplay.keys
    rm -f $GNOMEDEST/realplay.mime
    GNOMEAPPDEST=$HOME/.gnome/apps/Multimedia
    rm -f $GNOMEAPPDEST/realplayer.desktop
fi

# first install the app
mkdir -p $KDEAPPDEST
cat app.kdelnk | sed "s:__LOCATION__:`pwd`:g" > $KDEAPPDEST/RealPlayer.kdelnk
echo "Installed Realplayer link for KDE"

mkdir -p $GNOMEAPPDEST
cat realplay.desktop | sed "s:__LOCATION__:`pwd`:g" > $GNOMEAPPDEST/realplayer.desktop
echo "Installed Realplayer link for Gnome"

printf "%-30s%-50s\n" MIMETYPE "INSTALLED LOCATION" 
printf "%-30s%-50s\n" -------------------------- ----------------------------------------------------------
installmime audio/x-pn-realaudio             $KDEDEST "rmm ram"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/vnd.rn-realaudio           $KDEDEST "ra"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/smil                 $KDEDEST "smi smil" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime text/vnd.rn-realtext             $KDEDEST "rt"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime video/vnd.rn-realvideo           $KDEDEST "rv"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime image/vnd.rn-realflash           $KDEDEST "rf swf"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/x-shockwave-flash2-preview $KDEDEST "rf swf"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/sdp                  $KDEDEST "sdp"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/x-sdp                $KDEDEST "sdp"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/vnd.rn-realmedia     $KDEDEST "rm"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime image/vnd.rn-realpix             $KDEDEST "rp"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/wav                        $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-wav                      $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-pn-wav                   $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-pn-windows-acm           $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/basic                      $KDEDEST "au"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-pn-au                    $KDEDEST "au"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/aiff                       $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-aiff                     $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-pn-aiff                  $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST

if [ "$1" = "MP3" ] ; then
installmime audio/mpeg      $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mpg       $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mp3       $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpeg    $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpg     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mp3     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/rn-mpeg     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/X-MP3-draft-00 $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/MPA $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mpegurl   $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpegurl $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/scpls     $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-scpls   $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
fi

echo " "
echo "If you're using KDE, you'll need to restart your X session"
echo "now for the changes to take effect.  Changes to netscape" 
echo "mime configuration will take effect upon restarting netscape."
