#include "dock.h"

/************************************************/
// static member initializers

const string Base_Score::DELIMITER    = "########## ";

// 20 is magic
const int    Base_Score::FLOAT_WIDTH  = 20;

// length of "Score:" plus length of longest score name.
const int    Base_Score::STRING_WIDTH = 7 + 7;

/************************************************/
Base_Score::Base_Score()
{

    vdwA = NULL;
    vdwB = NULL;
    rep_radius_scale = 1.0;
}

/************************************************/
Base_Score::~Base_Score()
{

    delete[]vdwA;
    delete[]vdwB;

}

/************************************************/
void
Base_Score::initialize()
{


}
/************************************************/
void
Base_Score::calc_corner_coords()
{
    float           dx,
                    dy,
                    dz;

    dx = (span[0] - 1) * spacing;
    dy = (span[1] - 1) * spacing;
    dz = (span[2] - 1) * spacing;

    x_min = origin[0];
    x_max = origin[0] + dx;
    y_min = origin[1];
    y_max = origin[1] + dy;
    z_min = origin[2];
    z_max = origin[2] + dz;

    corners[0].assign_vals(x_min, y_min, z_min);
    corners[1].assign_vals(x_max, y_min, z_min);
    corners[2].assign_vals(x_max, y_min, z_max);
    corners[3].assign_vals(x_min, y_min, z_max);
    corners[4].assign_vals(x_min, y_max, z_min);
    corners[5].assign_vals(x_max, y_max, z_min);
    corners[6].assign_vals(x_max, y_max, z_max);
    corners[7].assign_vals(x_min, y_max, z_max);


}
/*************************************************/
// replicate grid interpolation for looking up phi
// values for electrostatic kxr
void
Base_Score::phi_corner_coords()
{
    float           dx,
                    dy,
                    dz;

    dx = (dspan[0]) * dspacing;
    dy = (dspan[1]) * dspacing;
    dz = (dspan[2]) * dspacing;

    phi_origin[0] = oldmid[0] - ((dspan[0] - 1) / 2) * dspacing;
    phi_origin[1] = oldmid[1] - ((dspan[1] - 1) / 2) * dspacing;
    phi_origin[2] = oldmid[2] - ((dspan[2] - 1) / 2) * dspacing;

    phi_x_min = phi_origin[0];
    phi_x_max = phi_origin[0] + dx;
    phi_y_min = phi_origin[1];
    phi_y_max = phi_origin[1] + dy;
    phi_z_min = phi_origin[2];
    phi_z_max = phi_origin[2] + dz;


    phi_corners[0].assign_vals(phi_x_min, phi_y_min, phi_z_min);
    phi_corners[1].assign_vals(phi_x_max, phi_y_min, phi_z_min);
    phi_corners[2].assign_vals(phi_x_max, phi_y_min, phi_z_max);
    phi_corners[3].assign_vals(phi_x_min, phi_y_min, phi_z_max);
    phi_corners[4].assign_vals(phi_x_min, phi_y_max, phi_z_min);
    phi_corners[5].assign_vals(phi_x_max, phi_y_max, phi_z_min);
    phi_corners[6].assign_vals(phi_x_max, phi_y_max, phi_z_max);
    phi_corners[7].assign_vals(phi_x_min, phi_y_max, phi_z_max);
}

/************************************************/
bool
Base_Score::check_box_boundaries(float x, float y, float z)
{

    if ((x < x_min) || (x >= x_max - 0.001) || (y < y_min)
        || (y >= y_max - 0.001) || (z < z_min) || (z >= z_max - 0.001))
        return false;
    else
        return true;
}

/************************************************/
// kxr 
bool
Base_Score::phi_box_boundaries(float x, float y, float z)
{

    if ((x < phi_x_min) || (x >= phi_x_max) || (y < phi_y_min) ||
        (y >= phi_y_max) || (z < phi_z_min) || (z >= phi_z_max))
        return false;
    else
        return true;
}

/************************************************/
void
Base_Score::find_grid_neighbors(float x, float y, float z)
{
    int             x_below,
                    x_above;
    int             y_below,
                    y_above;
    int             z_below,
                    z_above;
    int             x_nearest,
                    y_nearest,
                    z_nearest;
    float           x_int,
                    y_int,
                    z_int;
    float           corrected_coords[3];

    x_int = x - origin[0];
    y_int = y - origin[1];
    z_int = z - origin[2];

    x_nearest = NINT(x_int / spacing);
    x_below = INTFLOOR(x_int / spacing);
    // x_below = (int)floor(x_int/spacing);
    x_above = x_below + 1;
    if (x_nearest >= span[0]) {
        if (x_below >= span[0])
            x_nearest = span[0] - 1;
        else
            x_nearest = x_below;
    }
    if (x_nearest < 0) {
        if (x_above < 0)
            x_nearest = 0;
        else
            x_nearest = x_above;
    }

    y_nearest = NINT(y_int / spacing);
    y_below = INTFLOOR(y_int / spacing);
    // y_below = (int)floor(y_int/spacing);
    y_above = y_below + 1;
    if (y_nearest >= span[1]) {
        if (y_below >= span[1])
            y_nearest = span[1] - 1;
        else
            y_nearest = y_below;
    }
    if (y_nearest < 0) {
        if (y_above < 0)
            y_nearest = 0;
        else
            y_nearest = y_above;
    }

    z_nearest = NINT(z_int / spacing);
    z_below = INTFLOOR(z_int / spacing);
    // z_below = (int)floor(z_int/spacing);
    z_above = z_below + 1;
    if (z_nearest >= span[2]) {
        if (z_below >= span[2])
            z_nearest = span[2] - 1;
        else
            z_nearest = z_below;
    }
    if (z_nearest < 0) {
        if (z_above < 0)
            z_nearest = 0;
        else
            z_nearest = z_above;
    }

    nearest_neighbor = find_grid_index(x_nearest, y_nearest, z_nearest);

    neighbors[0] = find_grid_index(x_above, y_above, z_above);
    neighbors[1] = find_grid_index(x_above, y_above, z_below);
    neighbors[2] = find_grid_index(x_above, y_below, z_above);
    neighbors[3] = find_grid_index(x_below, y_above, z_above);
    neighbors[4] = find_grid_index(x_above, y_below, z_below);
    neighbors[5] = find_grid_index(x_below, y_above, z_below);
    neighbors[6] = find_grid_index(x_below, y_below, z_above);
    neighbors[7] = find_grid_index(x_below, y_below, z_below);

    corrected_coords[0] = x - origin[0];
    corrected_coords[1] = y - origin[1];
    corrected_coords[2] = z - origin[2];

    int_coords[0] = corrected_coords[0];
    int_coords[1] = corrected_coords[1];
    int_coords[2] = corrected_coords[2];

    cube_coords[0] = corrected_coords[0] / spacing - (float) (INTFLOOR(corrected_coords[0] / spacing)); // removed 
                                                                                                        // (int)
    cube_coords[1] = corrected_coords[1] / spacing - (float) (INTFLOOR(corrected_coords[1] / spacing)); // removed 
                                                                                                        // (int)
    cube_coords[2] = corrected_coords[2] / spacing - (float) (INTFLOOR(corrected_coords[2] / spacing)); // removed 
                                                                                                        // (int)
}

/************************************************/
void
Base_Score::find_phi_neighbors(float x, float y, float z)
{
    int             phi_x_below,
                    phi_x_above;
    int             phi_y_below,
                    phi_y_above;
    int             phi_z_below,
                    phi_z_above;
    int             phi_x_nearest,
                    phi_y_nearest,
                    phi_z_nearest;
    float           phi_x_int,
                    phi_y_int,
                    phi_z_int;
    float           corrected_coords[3];

    phi_x_int = x - phi_origin[0];
    phi_y_int = y - phi_origin[1];
    phi_z_int = z - phi_origin[2];

    phi_x_nearest = NINT(phi_x_int / dspacing);
    phi_x_below = INTFLOOR(phi_x_int / dspacing);
    // x_below = (int)floor(x_int/spacing);
    phi_x_above = phi_x_below + 1;
    if (phi_x_nearest >= dspan[0]) {
        if (phi_x_below >= dspan[0])
            phi_x_nearest = dspan[0] - 1;
        else
            phi_x_nearest = phi_x_below;
    }
    if (phi_x_nearest < 0) {
        if (phi_x_above < 0)
            phi_x_nearest = 0;
        else
            phi_x_nearest = phi_x_above;
    }

    phi_y_nearest = NINT(phi_y_int / dspacing);
    phi_y_below = INTFLOOR(phi_y_int / dspacing);
    // y_below = (int)floor(y_int/spacing);
    phi_y_above = phi_y_below + 1;
    if (phi_y_nearest >= dspan[1]) {
        if (phi_y_below >= dspan[1])
            phi_y_nearest = dspan[1] - 1;
        else
            phi_y_nearest = phi_y_below;
    }
    if (phi_y_nearest < 0) {
        if (phi_y_above < 0)
            phi_y_nearest = 0;
        else
            phi_y_nearest = phi_y_above;
    }

    phi_z_nearest = NINT(phi_z_int / dspacing);
    phi_z_below = INTFLOOR(phi_z_int / dspacing);
    // z_below = (int)floor(z_int/spacing);
    phi_z_above = phi_z_below + 1;
    if (phi_z_nearest >= dspan[2]) {
        if (phi_z_below >= dspan[2])
            phi_z_nearest = dspan[2] - 1;
        else
            phi_z_nearest = phi_z_below;
    }
    if (phi_z_nearest < 0) {
        if (phi_z_above < 0)
            phi_z_nearest = 0;
        else
            phi_z_nearest = phi_z_above;
    }

    phi_nearest_neighbor =
        find_phi_index(phi_x_nearest, phi_y_nearest, phi_z_nearest);

    phi_neighbors[0] = find_phi_index(phi_x_above, phi_y_above, phi_z_above);
    phi_neighbors[1] = find_phi_index(phi_x_above, phi_y_above, phi_z_below);
    phi_neighbors[2] = find_phi_index(phi_x_above, phi_y_below, phi_z_above);
    phi_neighbors[3] = find_phi_index(phi_x_below, phi_y_above, phi_z_above);
    phi_neighbors[4] = find_phi_index(phi_x_above, phi_y_below, phi_z_below);
    phi_neighbors[5] = find_phi_index(phi_x_below, phi_y_above, phi_z_below);
    phi_neighbors[6] = find_phi_index(phi_x_below, phi_y_below, phi_z_above);
    phi_neighbors[7] = find_phi_index(phi_x_below, phi_y_below, phi_z_below);

    corrected_coords[0] = x - phi_origin[0];
    corrected_coords[1] = y - phi_origin[1];
    corrected_coords[2] = z - phi_origin[2];

    phi_int_coords[0] = corrected_coords[0];
    phi_int_coords[1] = corrected_coords[1];
    phi_int_coords[2] = corrected_coords[2];

    phi_cube_coords[0] = corrected_coords[0] / dspacing - (float) (INTFLOOR(corrected_coords[0] / dspacing));   // removed 
                                                                                                                // (int)
    phi_cube_coords[1] = corrected_coords[1] / dspacing - (float) (INTFLOOR(corrected_coords[1] / dspacing));   // removed 
                                                                                                                // (int)
    phi_cube_coords[2] = corrected_coords[2] / dspacing - (float) (INTFLOOR(corrected_coords[2] / dspacing));   // removed 
                                                                                                                // (int)
}

/************************************************/
int
Base_Score::find_grid_index(int x, int y, int z)
{

    return span[0] * span[1] * z + span[0] * y + x;

}

/************************************************/
int
Base_Score::find_phi_index(int x, int y, int z)
{

    return dspan[0] * dspan[1] * z + dspan[0] * y + x;

}

/************************************************/
float
Base_Score::interpolate(float *grid)
{
    float           a1,
                    a2,
                    a3,
                    a4,
                    a5,
                    a6,
                    a7,
                    a8;
    float           value;
    int             out_of_bounds,
                    i;

    out_of_bounds = 0;
    for (i = 0; i < 8; i++)
        if ((neighbors[i] > size) || (neighbors[i] < 0))
            out_of_bounds = 1;

    if (out_of_bounds == 0) {
        a8 = grid[neighbors[7]];
        a7 = grid[neighbors[6]] - a8;
        a6 = grid[neighbors[5]] - a8;
        a5 = grid[neighbors[4]] - a8;
        a4 = grid[neighbors[3]] - a8 - a7 - a6;
        a3 = grid[neighbors[2]] - a8 - a7 - a5;
        a2 = grid[neighbors[1]] - a8 - a6 - a5;
        a1 = grid[neighbors[0]] - a8 - a7 - a6 - a5 - a4 - a3 - a2;

        value =
            a1 * cube_coords[0] * cube_coords[1] * cube_coords[2] +
            a2 * cube_coords[0] * cube_coords[1] +
            a3 * cube_coords[0] * cube_coords[2] +
            a4 * cube_coords[1] * cube_coords[2] + a5 * cube_coords[0] +
            a6 * cube_coords[1] + a7 * cube_coords[2] + a8;

        return value;
    } else {
        return grid[nearest_neighbor];
    }

}

/************************************************/
float
Base_Score::interpolphi(float *pgrid)
{
    double          a1,
                    a2,
                    a3,
                    a4,
                    a5,
                    a6,
                    a7,
                    a8;
    double          value;
    int             out_of_bounds,
                    i;

    out_of_bounds = 0;
    for (i = 0; i < 8; i++)
        if ((phi_neighbors[i] > dsize) || (phi_neighbors[i] < 0))
            out_of_bounds = 1;

    if (out_of_bounds == 0) {
        a8 = pgrid[phi_neighbors[7] - 1];
        a7 = pgrid[phi_neighbors[6] - 1] - a8;
        a6 = pgrid[phi_neighbors[5] - 1] - a8;
        a5 = pgrid[phi_neighbors[4] - 1] - a8;
        a4 = pgrid[phi_neighbors[3] - 1] - a8 - a7 - a6;
        a3 = pgrid[phi_neighbors[2] - 1] - a8 - a7 - a5;
        a2 = pgrid[phi_neighbors[1] - 1] - a8 - a6 - a5;
        a1 = pgrid[phi_neighbors[0] - 1] - a8 - a7 - a6 - a5 - a4 - a3 - a2;

        // printf("%8.3f%8.3f%8.3f%8.3f%8.3f%8.3f%8.3f%8.3f\n",
        // a1,a2,a3,a4,a5,a6,a7,a8);

        value =
            a1 * phi_cube_coords[0] * phi_cube_coords[1] * phi_cube_coords[2] +
            a2 * phi_cube_coords[0] * phi_cube_coords[1] +
            a3 * phi_cube_coords[0] * phi_cube_coords[2] +
            a4 * phi_cube_coords[1] * phi_cube_coords[2] +
            a5 * phi_cube_coords[0] + a6 * phi_cube_coords[1] +
            a7 * phi_cube_coords[2] + a8;


        return value;
    } else {
        return pgrid[phi_nearest_neighbor];
    }

}

/***************************************************/
// Calculate Internal Energy of the ligand kxr 010506
float
Base_Score::compute_ligand_internal_energy(DOCKMol & mol)
{
    float           int_vdw,
                    int_es,
                    distance;
    unsigned int    a1,
                    a2;

    float           ligand_internal_energy = 0.0;
    float           ie_diel = 2.0;
    int             ie_rep_exp = 12;
    int             ie_att_exp = 6;
    int_vdw = 0.0;
    int_es = 0.0;

    for (a1 = 0; a1 < mol.num_atoms - 1; a1++) {
        for (a2 = a1 + 1; a2 < mol.num_atoms; a2++) {
            if (check_box_boundaries(mol.x[a1], mol.y[a1], mol.z[a1])
                && check_box_boundaries(mol.x[a2], mol.y[a2], mol.z[a2])) {
                if ((mol.get_bond(a1, a2) == -1)
                    && (!mol.atoms_are_one_three(a1, a2))
                    && (!mol.atoms_are_one_four(a1, a2))
                    && (mol.amber_at_heavy_flag[a1]
                        && mol.amber_at_heavy_flag[a2])) {

                    distance =
                        pow((mol.x[a1] - mol.x[a2]),
                            2) + pow((mol.y[a1] - mol.y[a2]),
                                     2) + pow((mol.z[a1] - mol.z[a2]), 2);
                    distance = sqrt(distance);
                    int_es +=
                        (mol.charges[a1] * mol.charges[a2] * ie_diel) /
                        distance;
                    // int_vdw = 1043074.0/ pow(distance, (ie_rep_exp)) -
                    // 675.789/pow(distance, (ie_att_exp));
                    // commented out vdwA and vdwB for now. For Terry's eyes
                    // only
                    int_vdw +=
                        (vdwA[mol.amber_at_id[a1]] *
                         vdwA[mol.amber_at_id[a2]]) / pow(distance,
                                                          (ie_rep_exp)) -
                        (vdwB[mol.amber_at_id[a1]] *
                         vdwB[mol.amber_at_id[a2]]) / pow(distance,
                                                          (ie_att_exp));
                }
            }
        }
    }
    ligand_internal_energy = int_vdw + int_es;
    return ligand_internal_energy;
}
/************************************************/
void
Base_Score::init_vdw_energy(AMBER_TYPER & typer)
{
    int             i;

    delete[]vdwA;
    vdwA = NULL;

    delete[]vdwB;
    vdwB = NULL;

    vdwA = new float[typer.atom_typer.types.size()];
    vdwB = new float[typer.atom_typer.types.size()];

    for (i = 0; i < typer.atom_typer.types.size(); i++) {
        vdwA[i] =
            sqrt(typer.atom_typer.types[i].well_depth *
                 (att_exp / (rep_exp - att_exp)) *
                 pow((2 * rep_radius_scale * typer.atom_typer.types[i].radius), rep_exp));
        vdwB[i] =
            sqrt(typer.atom_typer.types[i].well_depth *
                 (rep_exp / (rep_exp - att_exp)) *
                 pow((2 * typer.atom_typer.types[i].radius), att_exp));
    }

}

