// definition of class Base_Score
// 
// This class defines the basic properties of all DOCK Score classes.
// Specific DOCK Score classes are to be derived from Base_Score.
// The characterization of a basic property is this equivalence:
// a property is basic to all Score classes if every Score class needs it
// and if a property is in Base_score then every Score class needs it and
// it is a basic property.
// 


#ifndef BASE_SCORE_H
#define BASE_SCORE_H

/**************************************************/
class           Base_Score {


  public:

    // use these for consistent formatting in output_score_summary
    static const std::string DELIMITER;
    static const int         FLOAT_WIDTH;
    static const int         STRING_WIDTH;

    bool            use_score;
    bool            use_primary_score;
    bool            use_secondary_score;
    bool            use_delphi_score;   // for delphi elec. score kxr
    bool            use_shape_score;    // for distmap filter kxr
    bool            use_solv_score;     // for solvent occlusion score kxr
    bool            redist_pos_desol;   // for redistributing positive
                                        // desolvation
    bool            use_odm_score;      // for occlusion desolvation method kxr
    bool            total_ligand_dsolv; // for total of volume based dsolv kxr
    bool            use_recep_dsolv;    // for delphi calc. receptor
                                        // desolvation kxr
    bool            use_chemgrid_score; // for chemgrid scoring kxr
    bool            use_conf_entropy;   // for conf entropy from rot bonds kxr
    bool            add_ligand_internal;        // for adding ligand internal
                                                // energy to score kxr
    bool            write_atomic_energy;
    double          current_score;

    int             size;
    int             dsize;      // For DelPhi grids kxr
    int             interpol_method;    // For choosing interpolation method
                                        // kxr
    float           spacing;
    float           dspacing;   // DelPhi grids kxr
    float           origin[3];
    float           phi_coords[3];
    float           phi_origin[3];      // DelPhi grid box origin kxr
    float           oldmid[3];  // DelPhi grid box center kxr
    int             span[3];
    int             dspan[3];   // kxr
    float          *vdwA;
    float          *vdwB;
    
    float	    rep_radius_scale;
    float	    att_exp, rep_exp;

    Base_Score();
    virtual ~ Base_Score();


    // Delphi grid coordinates kxr


    // DelPhi map interpolation fxns 

    XYZCRD          corners[8];
    XYZCRD          phi_corners[8];     // kxr
    int             neighbors[8];
    int             phi_neighbors[8];   // kxr
    float           cube_coords[3];
    float           phi_cube_coords[3]; // kxr
    float           int_coords[3];
    float           phi_int_coords[3];  // kxr
    int             nearest_neighbor;
    int             phi_nearest_neighbor;       // kxr
    float           x_min,
                    x_max,
                    y_min,
                    y_max,
                    z_min,
                    z_max;
    float           phi_x_min,
                    phi_x_max,
                    phi_y_min,
                    phi_y_max,
                    phi_z_min,
                    phi_z_max;  // kxr

    // Generic Function Definitions 

    virtual bool    compute_score(DOCKMol &) {
        return true;
    };
    virtual std::string  output_score_summary(float) {
        return "No Score";
    };

    float           compute_ligand_internal_energy(DOCKMol & mol);      // kxr
    void            initialize();
    void            init_lig_int_energy(AMBER_TYPER &);
    void            init_vdw_energy(AMBER_TYPER &);

    // Interpolation fxns 

    void            calc_corner_coords();
    void            phi_corner_coords();        // kxr
    bool            check_box_boundaries(float x, float y, float z);
    bool            phi_box_boundaries(float x, float y, float z);      // kxr
    void            find_grid_neighbors(float x, float y, float z);
    void            find_phi_neighbors(float x, float y, float z);      // kxr
    int             find_grid_index(int x, int y, int z);
    int             find_phi_index(int x, int y, int z);
    float           interpolate(float *grid);
    float           interpolphi(float *pgrid);  // kxr

    float           lowest_neighbor(float *grid);
    float           average_neighbor(float *grid);
    float           median_neighbor(float *grid);
    float           interpolate_trilinear(float *grid);
    float           interpolate_sublinear(float *grid);

    // Shape Filter Globals kxr 
    int             xmax;
    int             ymax;
    int             zmax;
    int             grddiv;

    // Receptor desolvation grid globals kxr 0306
    int             rdxmax;
    int             rdymax;
    int             rdzmax;
    int             rdgrdiv;

};

#endif  // BASE_SCORE_H

