using namespace std;

/********************************************************************/
class           SEGMENT {

  public:

    SEGMENT() {
        num_hvy_atoms = 0;
    };
    // //////////////////////////////////////////////////
    INTVec          atoms;      // list of atoms in the segment
    INTVec          bonds;      // list of bonds completely contained in the
                                // segment
    int             num_hvy_atoms;      // number of atoms in the segment
    INTVec          neighbors;  // neighboring segments
    INTVec          neighbor_bonds;     // rot bonds btwn segments
    INTVec          neighbor_atoms;     // test for segment at a time conf gen

    friend int      operator<(SEGMENT s1, SEGMENT s2) {
        return (s1.atoms.size() > s2.atoms.size());
    };
};

/********************************************************************/
class           LAYER_SEGMENT {

  public:

    LAYER_SEGMENT() {
        num_hvy_atoms = 0;
        rot_bond = -1;
        origin_segment = -1;
    };
    // //////////////////////////////////////////////////
    INTVec          atoms;      // list of atoms in the segment
    INTVec          bonds;      // list of bonds completely contained in the
                                // segment
    int             num_hvy_atoms;      // number of atoms in the segment
    int             rot_bond;   // rot bond to this segment from previous layer
    int             origin_segment;     // which segment this one is derived
                                        // from

    friend int      operator<(LAYER_SEGMENT s1, LAYER_SEGMENT s2) {
        return (s1.atoms.size() > s2.atoms.size());
    };
};

/********************************************************************/
class           LAYER {

  public:

    // //////////////////////////////////////////////////
    INTVec segments;            // List of segments in this layer
    int             num_segments;       // Number of segments in this layer

};

/********************************************************************/
class           ROT_BOND {

  public:

    // //////////////////////////////////////////////////
    int             atom1;      // first atom bound to atom 2 (to define angle)
    int             atom2;      // first atom of rotatable bond
    int             atom3;      // second atom of rotatable bond
    int             atom4;      // first atom bound to atom 3 (to define angle)
    int             seg1;       // Segment containing atom #2
    int             seg2;       // Segment containing atom #3
    int             bond_num;   // bond number in Mol
    float           initial_angle;      // initial angle from database
    float           current_angle;      // current angle

};

/********************************************************************/
class           CONFORMER {

  public:

    // General info
    float           score;      // score of current partial conf
    int             layer_num;  // current layer
    bool            used;       // flag to delete conformer once its used

    DOCKMol         structure;  // structure of conformer

};
/********************************************************************/
class           AG_Conformer_Search {

  public:

    //bool flexible_ligand;       // no
    int             anchor_size;        // 10

    int             num_anchor_poses;
    float           anchor_score_cutoff;                // energy cutoff value for next layer

    int             num_growth_poses;
    bool             growth_cutoff;
    float           growth_score_cutoff;  // energy cutoff value for growth

    bool            cluster;
    int             nc;         // number of confs/layer

    bool            use_clash_penalty;  // flag to use clash penalty or not
    float           clash_penalty;      // atom clash threshold value
    bool            use_internal_energy;        // 
    int             ie_att_exp;
    int             ie_rep_exp;
    float           ie_diel;
    float          *vdwA;
    float          *vdwB;

    DOCKMol         orig;       // original molecule struct
    DOCKMol         rmsd_reference;     // 

                    vector < SEGMENT > orig_segments;   // 
                    vector < LAYER_SEGMENT > layer_segments;    // 
                    vector < LAYER > layers;    // 
                    vector < INTPair > anchors; // pair list of anchor segments 
                                                // & sizes
                    vector < SCOREMol > anchor_positions;       // 
                    vector < DOCKMol > anchor_confs;    // 
                    vector < ROT_BOND > bond_list;      // 
                    vector < SCOREMol > pruned_confs;   // 


                    vector < bool > assigned_atoms;     // flags to track when
                                                        // an atom is assigned
                                                        // to a layer
    bool            last_conformer;     // 

    int             current_anchor;     // current anchor (anchors.size() -> 0)
    bool            return_anchor_value;        // used when no flex ligand is
                                                // requested
    bool            return_periph_value;        // used when no flex ligand is
                                                // requested

    INTVec          atom_seg_ids;       // id of which segment each atom
                                        // belongs to
    INTVec          bond_seg_ids;       // id of which segment each bond
                                        // belongs to (flex bonds assigned -1)

    INTVec          bond_tors_vectors;  // id of "start" atom for each bond WRT 
                                        // layers- for flexible minimization
                                        // during growth

    // ////////////////////////////////////////////////////////////////

                    AG_Conformer_Search();
                    virtual ~ AG_Conformer_Search();
    void            initialize();       // 
    void            input_parameters(Parameter_Reader & parm);  // 
    void            prepare_molecule(DOCKMol &);        // 
    void            identify_rigid_segments(DOCKMol &); // 
    void            extend_segments(int, int, DOCKMol &);       // 
    void            id_anchor_segments();       // 
    bool            next_anchor(DOCKMol &);     // 
    void            extend_layers(int, int, int);       // 
    bool            submit_anchor_orientation(DOCKMol &, bool); // 
    float           calc_layer_rmsd(CONFORMER &, CONFORMER &);  // 
    void            grow_periphery(Master_Score &, Simplex_Minimizer &, Bump_Filter &);        // 
    void            segment_torsion_drive(CONFORMER &, int, vector < CONFORMER > &);    // 
    void            activate_layer_segment(DOCKMol &, int, int);        // 
    void            reset_active_lists(DOCKMol &);      // 
    bool            segment_clash_check(DOCKMol &, int, int);   // 
    float           segment_internal_energy(DOCKMol &, int, int);       // 
    bool            next_conformer(DOCKMol &);  // 
    static int      conformer_less_than(CONFORMER a, CONFORMER b) {
        return a.score < b.score;
    };
};

/********************************************************************/
class           BRANCH {

  public:

    int             beatm,
                    bmatm,
                    bnhvy,
                    bnhyd,
                    confnum,
                    bi,
                    iconf;
    float           solvat,
                    apol;
    INTVec          level_values,
                    level_counts;

};

/********************************************************************/
class           ATOM_INFO {

  public:

    int             level,
                    vdwtype,
                    flagat,
                    lcolor;
    float           charge,
                    polsolv,
                    apolsolv;
    string          type;

    int             branch_num;
    INTVec          level_confs;

};

/********************************************************************/
class           HDB_MULTICONF {

  public:
    INTVecVecVec branch_confs;
    FLOATVecVec     branch_conf_scores;
    DOCKMol         mol;

    void            clear() {
        branch_confs.clear();
        branch_conf_scores.clear();
        mol.clear_molecule();
    };

};

/********************************************************************/
class           HDB_Conformer_Search {

  public:

    bool flexible_ligand;

    // heirarchy data
    DOCKMol         total_mol;

    // general data
    string          family_line,
                    name_line;
                    vector < string > branch_lines;
                    vector < string > level_lines;

    // family level data
    int             clunum,
                    nmol,
                    nbr,
                    fbr;
    string          name,
                    refcode;

    // branch level data
                    vector < BRANCH > branches;

    // atom hierarchy assignments
                    vector < ATOM_INFO > atoms;
    int             level_value,
                    level_count;

    int             num_anchor_poses;
                    vector < SCOREMol > anchor_positions;
                    vector < HDB_MULTICONF > docked_confs;
                    vector < DOCKMol > final_confs;

    INTVec          conf_state;
    INTVec          conf_state_max;

    bool            return_anchor_value;        // used when no flex ligand is
                                                // requested
    bool            return_periph_value;        // used when no flex ligand is
                                                // requested

    void            initialize();
    void            input_parameters(Parameter_Reader &);
    void            prepare_molecule(DOCKMol &);
    bool            next_anchor(DOCKMol &);
    bool            submit_anchor_orientation(DOCKMol &, bool); // 
    void            grow_periphery(Master_Score &, Bump_Filter &);
    void            deactivate_all_branches(DOCKMol &);
    void            deactivate_branch(DOCKMol &, int);
    bool            activate_branch_conformer(DOCKMol &, int, INTVec &);
    bool            return_next_branch_conformer(INTVec &, int, int &);
    void            skip_branch_conformer(INTVec &, int, int &);
    void            deactivate_molecule(DOCKMol &);
    void            activate_anchor(DOCKMol &);
    bool            next_conformer(DOCKMol &);
    bool            generate_mols_from_confs(HDB_MULTICONF &, DOCKMol &);

};

/********************************************************************/
class           Master_Conformer_Search {

  public:
    AG_Conformer_Search c_ag_conf;
    HDB_Conformer_Search c_hdb_conf;

    bool            flexible_ligand;
    bool            last_conformer;
    int             method;
    bool            more_anchors;
    bool            use_internal_energy;

    void            input_parameters(Parameter_Reader & parm);
    void            initialize();
    void            prepare_molecule(DOCKMol &);
    bool            next_anchor(DOCKMol &);
    bool            submit_anchor_orientation(DOCKMol &, bool);
    void            grow_periphery(Master_Score &, Simplex_Minimizer &, Bump_Filter &);
    bool            next_conformer(DOCKMol &);

};
