using namespace std;

/**************************************************/
class           Library_File:public Base_MPI {

  public:
    // data to identify database type (mol2 or heirarchy)
    int             db_type;    // 1=MOL2 (*.mol2), 2=HDB (*.db)
                    vector < DOCKMol > mol_branches;    // vector for the
                                                        // branches of an HDB
                                                        // molecule

    // general lib class data members
    bool            use_secondary_score;
    ifstream        ligand_in;

    ofstream        ligand_out_orients;
    ofstream        ligand_out_scored;
    ofstream        ligand_out_confs;
    ofstream        ligand_out_ranked;
    ofstream        secondary_ligand_out_confs;
    ofstream        secondary_ligand_out_scored;
    ofstream        secondary_ligand_out_ranked;

    bool            max_mol_limit;
    int             max_mols;
    bool            read_solvation,
                    read_color;
    int             initial_skip;
    int             total_mols;
    string          input_file_name;
    string          output_file_prefix;
    string          output_file_orient;
    string          output_file_confs;
    string          output_file_scored;
    string          output_file_ranked;
    string          secondary_output_file_confs;
    string          secondary_output_file_scored;
    string          secondary_output_file_ranked;

    DOCKMol         rmsd_reference;
    bool            calc_rmsd;
    int             num_anchors;
    int             num_orients;
    int             num_confs;
    bool            constant_rmsd_ref;
    string          constant_rmsd_ref_file;

    DOCKMol         bestmol;
    float           bestscore;
    string          bestdata;

                    vector < RANKMol > ranked_poses;
    int             high_position;
    float           high_score;
    int             num_scored_poses;
    int             num_secondary_scored_poses;

    bool            write_orients;
    bool            write_conformers;
    bool            write_secondary_conformers;
    bool            write_scored_ligands;

    bool            read_success;

    bool            rank_ligands;
                    vector < SCOREMol > ranked_list;
    int             max_ranked;
    bool            rank_secondary_ligands;
    int             max_secondary_ranked;
    bool            rank_ligand_output_override;
    float           rank_list_highest_energy;
    int             rank_list_highest_pos;
    int             completed;

    // final pose RMSD clustering
    bool            cluster_ranked_poses;
    INTVec          cluster_assignments;
    float           cluster_rmsd_threshold;
    int             num_clusterheads_rescore;

    // secondary pose rescoring
    vector < DOCKMol > poses_for_rescore;
    vector < SCOREMol > ranked_secondary_list;
    

    void            input_parameters_input(Parameter_Reader & parm);
    void	        input_parameters_output(Parameter_Reader &, Master_Score &, bool);

    void            initialize(int, char **, bool);
    void            open_files();
    void            close_files();

    bool            read_mol(DOCKMol &, bool);
    void            write_mol(DOCKMol &, ofstream &);
    bool            get_mol(DOCKMol &, bool, bool, Master_Score &, Simplex_Minimizer &);

    bool             submit_orientation(DOCKMol &, Master_Score &, bool);
    void            submit_conformation(Master_Score &);
    void            submit_secondary_conformation(Master_Score &, Simplex_Minimizer & min);
    void            submit_scored_pose(DOCKMol &, Master_Score &,
                                       Simplex_Minimizer & min);
    void	        submit_secondary_pose();
    void            rescore_conformation(DOCKMol &, Master_Score &,
                                       Simplex_Minimizer & min);
    void            secondary_rescore_poses(Master_Score &,
                                       Simplex_Minimizer &);
    void            write_scored_poses(bool);
    void            write_ranked_ligands();
    void            old_submit_scored_pose(DOCKMol &, Master_Score &);
    void            old_write_scored_poses();

    void            submit_rmsd_reference(DOCKMol &);
    float           calculate_rmsd(DOCKMol &);
    float           calculate_rmsd(DOCKMol &, DOCKMol &);
    void            cluster_list();

    // heirarchy DB functions
    string          hdb_atom_type_converter(int);
    bool            read_hierarchy_db(DOCKMol &, ifstream &);

};
