using namespace std;

#define VDWOFF -0.09
#define MAX_ATOM_REC 1000
#define MAX_ATOM_LIG 200

#define SQR(x) ((x)*(x))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

/*****************************************************************/
class           Bump_Filter:public Base_Score {

  public:

    //---------------------------------------------//
    //CONSTRUCTOR AND DESTRUCTOR
    Bump_Filter();
    virtual ~ Bump_Filter();

    //---------------------------------------------//
    //VARIABLES
    //data from bump filter
    FILE * grid_in;
    //file prefix of bump filter
    string          file_prefix;
    //array holding receptor bump data
    unsigned char  *bump;
    //flag to use bump filter
    bool            bump_filter;
    //user defined parameter for maximum number of bumps for anchor
    int             anchor_bump_max;
    //user defined parameter for maximum number of bumps for growth
    int             growth_bump_max;

    //---------------------------------------------//
    //FUNCTIONS

    //user defined parameters
    void            input_parameters(Parameter_Reader & parm);
    //call to read and initialize grid
    void            initialize();
    //read information from grid
    void            read_bump_grid();
    //evaluate whether anchor should pass filter
    bool            check_anchor_bumps(DOCKMol & mol, bool);
    //evaluate whether conformation should pass filter
    bool            check_growth_bumps(DOCKMol & mol);
    //calculate bump score
    int             get_bump_score(DOCKMol & mol);

};

/*****************************************************************/
class           Energy_Score:public Base_Score {

  public:



    FILE * grid_in;
    string          file_prefix;

    int             energy_score;
    float          *avdw;
    float          *bvdw;
    float          *es;
    float           vdw_scale;
    float           es_scale;
    char            atom_model;
    float           vdw_component;
    float           es_component;

                    Energy_Score();
                    virtual ~ Energy_Score();
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER &);

    void            read_nrg_grid();
    bool            compute_score(DOCKMol & mol);
    string          output_score_summary(float);

};

/*****************************************************************/
class           Continuous_Energy_Score:public Base_Score {

  public:

    string receptor_filename;
    DOCKMol         receptor;

    float           vdw_scale;
    float           es_scale;
    float           diel_screen;

    float           vdw_component;
    float           es_component;

                    Continuous_Energy_Score();
                    virtual ~ Continuous_Energy_Score();
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER &);
    bool            compute_score(DOCKMol &);
    string          output_score_summary(float);

};

/*****************************************************************/
class           Contact_Score:public Base_Score {

  public:

    FILE * grid_in;
    char            fname[100];
    char            bump_fname[100];
    string          file_prefix;

    int             contact_score;
    float           cutoff_distance;
    float           clash_overlap;
    float           clash_penalty;
    short int      *cnt;
    unsigned char  *bump;

                    Contact_Score();
                    virtual ~ Contact_Score();
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize();

    void            read_cnt_grid();
    bool            compute_score(DOCKMol & mol);
    string          output_score_summary(float);

};
