using namespace std;

#define VDWOFF -0.09
#define MAX_ATOM_REC 1000
#define MAX_ATOM_LIG 200

#define SQR(x) ((x)*(x))
#define CUB(x) ((x)*(x)*(x))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

/******************************************************************/
class           Shape_Filter:public Base_Score {

  public:

    FILE * shape_grid_in;
    string          shape_file_prefix;

    int             max_mismatch;       // corr. to bump_max kxr
    int             shape_filter;
    float           shape_score;

    void            input_parameters(Parameter_Reader & parm);
    void            initialize();

    void            read_shape_grid();
    bool            match_shape(DOCKMol & mol, bool bypass, bool shp_score);
    int             get_shape_score(DOCKMol & mol);

};

/*****************************************************************/
class           Chemgrid_Score:public Base_Score {

  public:

    FILE * grid_in;
    FILE           *solv_grid_in;
    FILE           *rdsol_grid_in;
    string          file_prefix;
    string          solv_file_prefix;
    string          rdsol_file_prefix;
    string          atomic_contrib;

    int             energy_score;
    float          *avdw;
    float          *bvdw;
    float          *es;
    float          *dslx;
    float          *dslb;
    float           vdw_scale;
    float           es_scale;
    float          *phi;

    bool            vdwA_allocated;
    bool            vdwB_allocated;
    char            atom_model;
    float           vdw_component;
    float           es_component;
    float           rdsol_component;
    float           polsolv_component;
    float           apolsolv_compontent;
    float           conf_entropy_component;
    float           bulksolv_component;
    float           explsolv_component;
    float           shape_score;

                    Chemgrid_Score();
                    virtual ~ Chemgrid_Score();
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER &);

    // void read_nrg_grid();
    void            read_phi_grid();
    void            read_chm_grid();
    void            read_odm_grid();
    void            read_rdsol_grid();
    bool            compute_score(DOCKMol & mol);
    string          output_score_summary(float);

    // DelPhi BKS interpolation data kxr
    float           phi_space[3];
    void            real_to_phi_coords(float x, float y, float z);
    float           interpolpot();

    // Solvent Occlusion grid BKS data kxr
    int             solv_grd_ex[3];
    int             perang;
    void            read_solv_grid();
    float           solv_score;
    float           psolv_score;
    float           apsolv_score;
    float           socc_component;
    bool            redist_positve_desolv(DOCKMol & mol);       // redist lig.
                                                                // desol BKS
                                                                // kxr
    bool            compute_ligand_desolvation(DOCKMol & mol, int atom_id);     // Lig. 
                                                                                // desolvation 
                                                                                // kxr
    // float compute_ligand_internal_energy(DOCKMol &mol); //Ligand int. energy 
    // kxr

    // Receptor desolvation kxr
    float           rdsol_score;
    float           solx_val;
    float           solb_val;
    bool            compute_rdsol_score(DOCKMol & mol, int atom_id);    // Rec. 
                                                                        // desolvation 
                                                                        // kxr
    bool            compute_odm_score(DOCKMol & mol, int atom_id);      // Occup. 
                                                                        // desolvation 
                                                                        // kxr


    // Shape score BKS kxr
    // float atomic_shape_score;
    float           get_atom_shape_score(float x, float y, float z);
    float           compute_buried_fraction(DOCKMol & mol);
    bool            atom_buried(DOCKMol & mol, int atom_id);
    float           get_conf_entropy(DOCKMol & mol);


};
