using namespace std;

/********************************************************************/
class           Simplex_Minimizer {

  public:

    bool            minimize_ligand;
    vector<TORSION> torsions;
    INTVec          torsion_scale_factors;
    INTVec          bond_vectors;

    // state variables
    int             current_cycle;
    int             random_seed;

    // simplex parameters
    bool            advanced_min_params;
    int             max_iterations;
    int             max_cycles;
    float           score_converge;
    float           cycle_converge;
    float           trans_step_size;
    float           rot_step_size;
    float           tors_step_size;

    // anchor minimization parameters
    bool            use_min_rigid_anchor;
    int             anchor_min_max_iterations;
    int             anchor_min_max_cycles;
    float           anchor_min_score_converge;
    float           anchor_min_cycle_converge;
    float           anchor_min_trans_step_size;
    float           anchor_min_rot_step_size;
    float           anchor_min_tors_step_size;

    // flex search minimization parameters
    bool            use_min_flex_growth;
    int             flex_min_max_iterations;
    int             flex_min_max_cycles;
    float           flex_min_score_converge;
    float           flex_min_cycle_converge;
    float           flex_min_trans_step_size;
    float           flex_min_rot_step_size;
    float           flex_min_tors_step_size;

    // final minimization parameters
    bool            final_min;
    bool            final_min_add_internal;
    int             final_min_max_iterations;
    int             final_min_max_cycles;
    float           final_min_score_converge;
    float           final_min_cycle_converge;
    float           final_min_trans_step_size;
    float           final_min_rot_step_size;
    float           final_min_tors_step_size;
    bool            final_pose_for_min;
    float	   final_min_rep_radius_scale;


    // parameters for minimization with secondary score
    bool            secondary_min_pose;
    int             secondary_min_max_iterations;
    int             secondary_min_max_cycles;
    float           secondary_min_score_converge;
    float           secondary_min_cycle_converge;
    float           secondary_min_trans_step_size;
    float           secondary_min_rot_step_size;
    float           secondary_min_tors_step_size;
    bool            secondary_advanced_min_params;
    bool            secondary_min_add_internal;
    bool            secondary_final_pose_for_min;

    // functions
    void            input_parameters(Parameter_Reader & parm,
                                     bool flexible_ligand, Master_Score &);
    void            initialize();
    void            minimize(Base_Score &, DOCKMol &, FLOATVec &, int, float,
                             int, float, float, float, float);
    float           simplex_minimize(Base_Score &, DOCKMol &, FLOATVec &, int,
                                     float, float, float, float);
    bool            simplex_score(Base_Score &, DOCKMol &, DOCKMol &,
                                  FLOATVec &, float, float, float);
    void            scale_simplex_vector(FLOATVec &, FLOATVec &, float, float,
                                         float);
    void            vector_to_dockmol(DOCKMol &, FLOATVec &);
    void            minimize_rigid_anchor(DOCKMol &, Master_Score &);
    void            minimize_flexible_growth(DOCKMol &, Master_Score &,
                                             INTVec &);
    void            minimize_flexible_growth(DOCKMol &, Master_Score &);
    void            minimize_final_pose(DOCKMol &, Master_Score &, AMBER_TYPER &);
    void            secondary_minimize_pose(DOCKMol &, Master_Score &);
    void            id_torsions(DOCKMol &, FLOATVec &);

};
