#include "dock.h"

/*
 * =================================================================== 
 */
int
check_commandline_flag(char **argv, int argc, char *flag)
{
    int             i;

    for (i = 0; i < argc; i++) {
        if (argv[i] != NULL) {
            if (strcmp(argv[i], flag) == 0) {
                if (i < (argc - 1)) {
                    if (argv[i + 1][0] == '-')
                        return i;
                } else
                    return i;
            }
        }
    }

    return -1;

}


/*
 * =================================================================== 
 */
int
check_commandline_argument(char **argv, int argc, char *flag)
{
    int             i;

    for (i = 0; i < argc; i++) {
        if (argv[i] != NULL) {
            if (strcmp(argv[i], flag) == 0) {
                if ((i < (argc - 1)) && (argv[i + 1][0] != '-'))

                    return i;
            }
        }
    }

    return -1;

}

/*
 * =================================================================== 
 */
string
parse_commandline_argument(char **argv, int argc, char *flag)
{
    int             i;
    string          value;

    value = "";
    for (i = 0; i < argc; i++) {
        if (argv[i] != NULL) {
            if (strcmp(argv[i], flag) == 0) {
                value.append(argv[i + 1]);
            }
        }
    }
    return value;

}

/************************************************/
DOCKVector
DOCKVector::operator=(const DOCKVector & v)
{

    x = v.x;
    y = v.y;
    z = v.z;

    return *this;

}

/************************************************/
DOCKVector & DOCKVector::operator+=(const DOCKVector & v)
{

    x += v.x;
    y += v.y;
    z += v.z;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::operator+=(const float &f)
{

    x += f;
    y += f;
    z += f;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::operator-=(const DOCKVector & v)
{

    x -= v.x;
    y -= v.y;
    z -= v.z;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::operator-=(const float &f)
{

    x -= f;
    y -= f;
    z -= f;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::operator*=(const float &f)
{

    x *= f;
    y *= f;
    z *= f;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::operator/=(const float &f)
{

    x /= f;
    y /= f;
    z /= f;

    return *this;
}

/************************************************/
DOCKVector & DOCKVector::normalize_vector()
{
    float
        len;

    len = length();

    if (len != 0) {
        x = x / len;
        y = y / len;
        z = z / len;
    }

    return *this;
}

/************************************************/
float
DOCKVector::length() const
{
    float           len;

    len = sqrt(x * x + y * y + z * z);

    return len;
}

/************************************************/
float
DOCKVector::squared_length() const
{
    float           len;

    len = x * x + y * y + z * z;

    return len;
}

/************************************************/
float
DOCKVector::squared_dist(const DOCKVector & v) const
{
    float           dist;

    dist =
        (x - v.x) * (x - v.x) + (y - v.y) * (y - v.y) + (z - v.z) * (z - v.z);

    return dist;
}

/************************************************/
int
operator==(const DOCKVector & v1, const DOCKVector & v2)
{

    if ((v1.x == v2.x) && (v1.y == v2.y) && (v1.z == v2.z))
        return (true);
    else
        return (false);

}

/************************************************/
int
operator!=(const DOCKVector & v1, const DOCKVector & v2)
{

    if ((v1.x != v2.x) || (v1.y != v2.y) || (v1.z != v2.z))
        return (true);
    else
        return (false);

}

/************************************************/
DOCKVector
operator+(const DOCKVector & v1, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = v1.x + v2.x;
    vec.y = v1.y + v2.y;
    vec.z = v1.z + v2.z;

    return vec;
}

/************************************************/
DOCKVector
operator+(const float &f, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = f + v2.x;
    vec.y = f + v2.y;
    vec.z = f + v2.z;

    return vec;
}

/************************************************/
DOCKVector
operator+(const DOCKVector & v1, const float &f)
{
    DOCKVector      vec;

    vec.x = v1.x + f;
    vec.y = v1.y + f;
    vec.z = v1.z + f;

    return vec;
}

/************************************************/
DOCKVector
operator-(const DOCKVector & v1, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = v1.x - v2.x;
    vec.y = v1.y - v2.y;
    vec.z = v1.z - v2.z;

    return vec;
}

/************************************************/
DOCKVector
operator-(const DOCKVector & v)
{
    DOCKVector      vec;

    vec.x = -v.x;
    vec.y = -v.y;
    vec.z = -v.z;

    return vec;
}

/************************************************/
DOCKVector
operator-(const DOCKVector & v1, const float &f)
{
    DOCKVector      vec;

    vec.x = v1.x - f;
    vec.y = v1.y - f;
    vec.z = v1.z - f;

    return vec;
}

/************************************************/
DOCKVector
operator*(const DOCKVector & v1, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = v1.x * v2.x;
    vec.y = v1.y * v2.y;
    vec.z = v1.z * v2.z;

    return vec;
}

/************************************************/
DOCKVector
operator*(const float &f, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = f * v2.x;
    vec.y = f * v2.y;
    vec.z = f * v2.z;

    return vec;
}

/************************************************/
DOCKVector
operator*(const DOCKVector & v1, const float &f)
{
    DOCKVector      vec;

    vec.x = v1.x * f;
    vec.y = v1.y * f;
    vec.z = v1.z * f;

    return vec;
}

/************************************************/
DOCKVector
operator/(const DOCKVector & v1, const float &f)
{
    DOCKVector      vec;

    vec.x = v1.x / f;
    vec.y = v1.y / f;
    vec.z = v1.z / f;

    return vec;
}

/************************************************/
float
dot_prod(const DOCKVector & v1, const DOCKVector & v2)
{
    float           dp;

    dp = v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;

    return dp;
}

/************************************************/
DOCKVector
cross_prod(const DOCKVector & v1, const DOCKVector & v2)
{
    DOCKVector      vec;

    vec.x = v1.y * v2.z - v1.z * v2.y;
    vec.y = -v1.x * v2.z + v1.z * v2.x;
    vec.z = v1.x * v2.y - v1.y * v2.x;

    return vec;
}

/************************************************/
float
get_vector_angle(const DOCKVector & v1, const DOCKVector & v2)
{
    float           mag,
                    prod;
    float           result;

    mag = v1.length() * v2.length();
    prod = dot_prod(v1, v2) / mag;

    if (prod < -0.999999)
        prod = -0.9999999f;

    if (prod > 0.9999999)
        prod = 0.9999999f;

    if (prod > 1.0)
        prod = 1.0f;

    result = (acos(prod) / PI) * 180;

    return result;
}

/************************************************/
float
get_torsion_angle(DOCKVector & v1, DOCKVector & v2, DOCKVector & v3,
                  DOCKVector & v4)
{
    float           torsion;
    DOCKVector      b1,
                    b2,
                    b3,
                    c1,
                    c2,
                    c3;

    b1 = v1 - v2;
    b2 = v2 - v3;
    b3 = v3 - v4;

    c1 = cross_prod(b1, b2);
    c2 = cross_prod(b2, b3);
    c3 = cross_prod(c1, c2);

    if (c1.length() * c2.length() < 0.001) {
        torsion = 0.0;
    } else {
        torsion = get_vector_angle(c1, c2);
        if (dot_prod(b2, c3) > 0.0)
            torsion *= -1.0;
    }

    return (torsion);
}

/***********************************/
void
Parameter_Reader::initialize(int argc, char **argv)
{

    if (check_commandline_argument(argv, argc, "-i") != -1) {
        sprintf(param_file_name, "%s",
                parse_commandline_argument(argv, argc, "-i").c_str());
        read_params();
    } else {
        cout << endl <<
            "Usage:\n\tdock6 -i filename.in [-o filename.out] [-v]" <<
            endl;
        exit(0);
    }

    verbosity = 0;
    // the verbose flag is used for extra scoring information
    if (check_commandline_flag(argv, argc, "-v") != -1)
        verbosity = 1;

    if (check_commandline_argument(argv, argc, "-o") != -1)
        no_stdin = true;
    else
        no_stdin = false;

}
/***********************************/
int
Parameter_Reader::verbosity_level()
{

    return verbosity;

}
/***********************************/
void
Parameter_Reader::read_params()
{

    PARAMETER       param;

    param_file_in.open(param_file_name);

    while (param_file_in >> param.name) {
        param_file_in >> param.value;
        params_in.push_back(param);
        param.clear();
    }

    for (int i = 0; i < params_in.size(); i++) {
        params_in[i].flag = 0;
    }

    param_file_in.close();

    num_missing_params = 0;

}

/***********************************/
string
Parameter_Reader::query_param(string name, string default_value,
                              string legal_values)
{
    int             i,
                    found;
    string          value;
    PARAMETER       param;
    int             prompt_count;

    found = 0;
    value = "";
    cout.setf(ios::left);

    for (i = 0; i < params_in.size(); i++) {
        if (params_in[i].name == name) {
            if (legal_values.empty() ||
                legal_values.find(params_in[i].value) != string::npos) {
                if (check_duplicates(params_in[i])) {
                    params_out.push_back(params_in[i]);
                    params_in[i].flag = 1;
                    found = 1;
                    value = params_in[i].value;
                    cout.width(61);
                    cout << params_in[i].name.c_str() << params_in[i].
                        value << endl;
                    cout.flush();
                } else
                    cout << "Warning: parameter " << params_in[i].
                        name << " already found in parameters list.\n";
            } else {
                params_in[i].flag = 2;
                cout << "Illegal value found for " << params_in[i].
                    name << ".\n";
            }
        }
    }

    if (found == 0) {
        if (no_stdin == true) {
            param.name = name;
            param.value = default_value;
            value = default_value;
            cout << "WARNING:  No parameter value found for \"" << param.
                name << "\".  Default value of \"" << param.
                value << "\" used." << endl;
            params_out.push_back(param);
            cout.flush();
        } else {
            param.name = name;

            cout.width(60);
            cout << name.
                c_str() << " [" << default_value << "] (" << legal_values <<
                "):";
            cout.flush();

            if (cin.peek() != '\n') {
                cin >> value;
                cin.get();
            } else {
                value = default_value;
                cin.get();
            }

            prompt_count = 0;
            while ((!legal_values.empty()) && 
                   (legal_values.find(value) == string::npos) &&
                   (prompt_count < 5)) {
                cout << "Illegal value for " << param.
                    name << ", please re-enter: ";
                cin >> value;
                cin.get();
                cout << endl;
                prompt_count++;
            }

            if (legal_values.empty() ||
                legal_values.find(value) != string::npos) {
                param.value = value;
                params_out.push_back(param);
            } else {
                num_missing_params++;
                cout <<
                    "Error: Missing parameter/value pair.  Too many illegal values."
                    << endl;
                cout << name.
                    c_str() << " [" << default_value << "] (" << legal_values <<
                    ")" << endl;
            }


        }
    }


    return value;
}

/***********************************/
int
Parameter_Reader::check_duplicates(PARAMETER & param)
{
    int             i,
                    found;

    found = 1;

    for (i = 0; i < params_out.size(); i++) {
        if (param.name == params_out[i].name)
            found = 0;
    }

    return found;
}

/***********************************/
void
Parameter_Reader::write_params()
{
    int             i;

    // cout <<
    // "__________________________________________________________________________________________" 
    // << endl;
    cout <<
        "------------------------------------------------------------------------------------------"
        << endl;

    param_file_out.open(param_file_name);

    param_file_out.setf(ios::left);
    for (i = 0; i < params_out.size(); i++) {
        param_file_out.width(61);
        param_file_out << params_out[i].name.c_str() << params_out[i].
            value << endl;
    }

    param_file_out.close();

}

/***********************************/
bool
Parameter_Reader::parameter_input_successful()
{

    if (num_missing_params > 0) {
        cout << endl << endl << "Parameterization Failed." << endl;
        cout << num_missing_params << " missing parameters." << endl;
        return false;
    }

    return true;
}

/******************************************************/
int             get_matrix_from_quaternion(float m[3][3],       /* rotation
                                                                 * matrix */
                                           float qin[3] /* input independent
                                                         * quaternion elements */
    ) {
    int             i;          /* iterator */
    float           qn;         /* dependent quaternion element, q-naught */
    float           qn2;        /* square of q-naught */
    float           q[3];       /* independent quaternion elements */
    float           q2[3];      /* square of independent quaternion elements */
    float           sum2;       /* sum of squares of independent q values */
    float           sum;        /* sum of independent q values */

    float           temp1,
                    temp2;

    /*
     * Check that each q-value is between -1.0 and 1.0.
     * If not, remap into this range using wrap-around.
     * Compute q-squared values and their sum
     * 10/96 te
     */
    for (i = 0, sum2 = 0.0; i < 3; i++) {
        q[i] = qin[i];

        if (q[i] > 1.0)
            q[i] = fmod(q[i] + 1.0, 2.0) - 1.0;

        else if (q[i] < -1.0)
            q[i] = fmod(q[i] - 1.0, 2.0) + 1.0;

        sum2 += q2[i] = (q[i] * q[i]);
    }

    /*
     * If the sum-of-squares is less than 1.0, compute q-naught
     * 10/96 te
     */
    if (sum2 < 1.0) {
        qn2 = 1.0 - sum2;
        qn = sqrt(qn2);
    }

    /*
     * If the sum is 1.0, set q-naught to zero
     * 10/96 te
     */
    else if (sum2 == 1.0)
        qn = qn2 = 0.0;

    /*
     * Otherwise, renormalize q-values and set q-naught to zero
     * 10/96 te
     */
    else {
        for (i = 0; i < 3; i++)
            q2[i] /= sum2;

        for (i = 0, sum = sqrt(sum2); i < 3; i++)
            q[i] /= sum;

        qn = qn2 = 0.0;
    }

    /*
     * Compute rotation matrix elements
     * 10/96 te
     */

    m[0][0] = qn2 + q2[0] - q2[1] - q2[2];

    temp1 = q[0] * q[1];
    temp2 = qn * q[2];
    m[0][1] = 2.0 * (temp1 + temp2);

    temp1 = q[0] * q[2];
    temp2 = qn * q[1];
    m[0][2] = 2.0 * (temp1 - temp2);

    temp1 = q[0] * q[1];
    temp2 = qn * q[2];
    m[1][0] = 2.0 * (temp1 - temp2);

    m[1][1] = qn2 - q2[0] + q2[1] - q2[2];

    temp1 = q[1] * q[2];
    temp2 = qn * q[0];
    m[1][2] = 2.0 * (temp1 + temp2);

    temp1 = q[0] * q[2];
    temp2 = qn * q[1];
    m[2][0] = 2.0 * (temp1 + temp2);

    temp1 = q[1] * q[2];
    temp2 = qn * q[0];
    m[2][1] = 2.0 * (temp1 - temp2);

    m[2][2] = qn2 - q2[0] - q2[1] + q2[2];

    return true;
}

// /////////////////////////////////////////////////////////////////////////////////////
INTVecVecVec    child_list;
// int *child_list;
