      SUBROUTINE MECID(EIGS,GSE,EIGA,DIAG)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'SIZES'
      DIMENSION EIGS(*), EIGA(*), DIAG(*)
************************************************************************
*
*   MECID CALCULATES THE EFFECT OF REMOVING THE ELECTRONS INVOLVED IN
*   THE C.I. FROM THE GROUND-STATE CONFIGURATION, AND CALCULATES THE
*   MICROSTATE ENERGIES OF THE MICROSTATES INVOLVED IN THE C.I.
*
*  THE QUANTITIES NMOS, NELEC, AND LAB, AND THE ARRAYS EIGS, OCCA,
*  MICROA, AND MICROB ARE USED, BUT UNCHANGED ON EXIT
*
*   ON EXIT, GSE IS THE ELECTRONIC ENERGY OF STABILIZATION DUE TO
*            REMOVAL OF THE ELECTRONS INVOLVED IN THE C.I.
*
*            EIGA HOLDS THE ONE-ELECTRON ENERGY LEVELS RESULTING FROM
*            REMOVAL OF THE ELECTRONS INVOLVED IN THE C.I.
*
*            DIAG HOLDS THE MICROSTATE ENERGIES OF ALL STATES INVOLVED
*            IN THE C.I.  THIS CAN BE USED AS THE DIAGONAL OF A C.I.
*            MATRIX
*
************************************************************************
      COMMON /BASEOC/ OCCA(NMECI)
      COMMON /MICROS/ MICROA(NMECI,4*NMECI**2),MICROB(NMECI,4*NMECI**2)
      COMMON /CIBITS/ NMOS,LAB,NELEC, NBO(3)
      COMMON /XYIJKL/ XY(NMECI,NMECI,NMECI,NMECI)
      GSE=0.D0
      DO 20 I=1,NMOS
         X=0.0
         DO 10 J=1,NMOS
   10    X=X+(2.D0*XY(I,I,J,J)-XY(I,J,I,J))*OCCA(J)
         EIGA(I)=EIGS(I+NELEC)-X
         GSE=GSE+EIGA(I)*OCCA(I)*2.D0
         GSE=GSE+XY(I,I,I,I)*OCCA(I)*OCCA(I)
         DO 20 J=I+1,NMOS
   20 GSE=GSE+2.D0*(2.D0*XY(I,I,J,J) - XY(I,J,I,J))*OCCA(I)*OCCA(J)
      DO 30 I=1,LAB
   30 DIAG(I)=DIAGI(MICROA(1,I),MICROB(1,I),EIGA,XY,NMOS)-GSE
      RETURN
      END
