#ifndef LATTICE_H
#define LATTICE_H

#ifdef __cplusplus
extern "C" {
#endif

  float *alloc_wt(int *nr, float a, float h);
  void free_wt(float *wt);

  void nonperiodic_lattice_cutoff(float *e, const float *q,
      int nx, int ny, int nz, const float *wt, int nr);
  void periodic_lattice_cutoff(float *e, const float *q,
      int nx, int ny, int nz, const float *wt, int nr);

  void nonperiodic_lattice_direct(float *e, const float *q,
      int nx, int ny, int nz, float a, float h);
  void periodic_lattice_direct(float *e, const float *q,
      int nx, int ny, int nz, float a, float h);

#ifdef __cplusplus
}
#endif

#endif /* LATTICE_H */
