#include <stdio.h>
#include <rpc/rpc.h> 

#ifndef _MDCOMM_H
#define _MDCOMM_H
#endif

#if defined (SGI) || defined(__cplusplus) || \
    defined(FUNCPROTO) || defined(__STDC__)
#ifndef _ansi_prototypes
#define _ansi_prototypes 1
#endif
#endif

#if defined (SGI) || defined (SYSV)
typedef void * shmaddr_t;
#else
typedef char * shmaddr_t;
#endif

#ifdef __cplusplus

#ifndef _ansi_prototypes
#define _ansi_prototypes 1
#endif

#ifndef EXTERN
#define EXTERN extern "C"
#endif

#ifndef EXTERNC
#define EXTERNC extern "C"
#endif

#else /* ! __cplusplus */

#ifndef EXTERN
#define EXTERN extern
#endif

#ifndef EXTERNC
#define EXTERNC extern
#endif

#endif

#ifndef _AP
#ifdef _ansi_prototypes
#define _AP(args)       args
#else
#define _AP(args)       ()
#endif
#endif /* _AP */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef MAX
#define MAX(a,b) ((a>b)?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b) ((a<b)?(a):(b))
#endif

typedef enum {
  MDC_BYTE,
  MDC_INT,
  MDC_FLOAT,
  MDC_DOUBLE
} mdc_datatype_t;

extern int _mdc_init;

/* From dynd.h */
typedef struct dyndState {
  int   *step;
  float *cpu,
        *temp,
        *epot,
        *etot,
        *evdw,
        *eelec,
        *esup,
        *ehbo,
        *ebond,
        *eangle,
        *edihed,
        *eimpr;
  float *x, *y, *z;
  float *dt;
  int   *nPatches;   /* Number of patches active. If 0, patch info: invalid */
                     /* Following 9 arrays contain *nPatches information,
                        but are of absolute size *maxPatches. */
  float *patchX, *patchY, *patchZ; /* Patch coordinates for lower left */
  float *patchXLen, *patchYLen, *patchZLen;
  float *patchLoad, *patchAtoms, *patchNode;
} dyndState;

/* -------------------------------------------------------- */

/* From md_apputils.h */
typedef struct md_opt {
  char *keyword;
  int  type;      /* 0 = float, 1 = int, 2 = string */
  int  required;  /* non-zero = required            */
  char *def;      /* Default value                  */
  char *desc;     /* Textual description of option  */
} md_opt;

typedef struct md_optlist {
  int  count;     /* How many options are there?    */
  struct md_opt **opt;
  char *daemon;   /* The default daemon program.    */
} md_optlist;

typedef struct md_optlist mdc_optlist_t;

typedef struct mdc_proglist {
  char *prog;
  struct mdc_proglist *next;
} mdc_proglist;
typedef struct mdc_proglist *mdc_proglist_t;

typedef struct mdc_fds {
  int   doxdr;       /* Flag set if data conversion done         */
  int   isock;       /* File descriptor - input socket           */
  int   osock;       /* File descriptor - output socket          */
  FILE *istream;     /* I/O stream - input (for XDR stream)      */
  FILE *ostream;     /* I/O stream - output ( " " )              */
  XDR   xdrin;       /* Actual XDR handles                       */
  XDR   xdrout;
} mdc_fds;

/* 
 * mdc_appd is a descriptor for a client program.
 * It contains information needed to contact:
 *   Daemon
 *   Consumer
 */

typedef struct mdc_appd {
  int connected;
  int local;
  pid_t daemon_pid;
  char *machtype;
  char *host;
  struct mdc_fds daemonfds;
} mdc_appd;

/*
 * md_arena provides a handle for producer/consumer processes
 * for coordinate transfer.
 */
typedef struct md_arena {
  int   shmid;            /* Shared memory segment ID   */
  shmaddr_t *shmaddr;     /* Shared memory address      */
  int   semid;            /* Semaphore ID               */
  int   sock;             /* Consumer socket descriptor */
  int   pid;              /* Consumer process ID        */
  struct mdc_appd *appd;  /* Client/Daemon descriptors  */
  unsigned int status;    /* Status bits                */
} md_arena;

typedef struct md_arena mdc_arena_t;

/* -------------------------------------------------------- */

/* From md_struct.h */

typedef struct md_struct {
  int   nameLen;            /* Number of characters in nAtom{Type,Name}s */

  int   nAtoms;             /* Number of atoms in the simulation */
  int   *atomTypeIdx;       /* Array of len. nAtoms, indexing atomTypeList */
  int   *atomNameIdx;       /* Array of len. nAtoms, indexing atomNameList */
  char  *resIds;            /* Array of nAtoms residue ids, len. nameLen */
  char  *resNames;          /* Array of nAtoms residue names, len. nameLen */
  char  *segIds;            /* Array of nAtoms segment names, len nameLen */
  float *mass;              /* Array of nAtoms mass (sr_Atom.ms) */
  float *charge;            /* Array of nAtoms charges (sr_Atom.q) */
  float *g;                 /* "b1" in MD */
  float *k;                 /* "b2" in MD */

  float *radii;             /* Array of nAtoms radii */

  int   nHBondDonors;       /* Number of hydrogen bond donors */
  int   *donor;             /* List of h-donors (index into atoms) */
  int   *donorh;            /* List of associated h-donors */

  int   nHBondAcceptors;    /* Number of hydrogen bond acceptors */
  int   *acceptor;          /* List of h-acceptors (index into atoms) */
  int   *acceptora;         /* List of associated h-acceptors */
    
  int   nAtomTypes;         /* Number of unique atom types */
  char  *atomTypeList;      /* List of unique types, each of length nameLen */

  int   nAtomNames;         /* Number of unique atom names */
  char  *atomNameList;      /* List of unique names, each of length nameLen */

  int   nBonds;             /* Number of bonds */
  int   *bonds;             /* Array of 2*nBonds bonds for atom pairs */

  int   maxPatches;         /* Maximum number of patches that may be sent */
} md_struct;

struct mdc_app_arena {
  int csock;
  int dsock;
  struct mdc_fds consumer;
  int doxdr;
  int connected;
  int disconnecting;
  int xferinterval;
  int xfercount;
  FILE *stdOut, *stdErr;
  int (*sendStatic)_AP((struct mdc_app_arena *));
  int (*sendDynamic)_AP((struct mdc_app_arena *));
};
typedef struct mdc_app_arena mdc_app_arena;

struct mdc_job {
  int jid;
  int uid;
  int port;
  char *prog;
};
typedef struct mdc_job mdc_job;

struct mdc_joblist {
  mdc_job *job;
  struct mdc_joblist *next;
};
typedef struct mdc_joblist mdc_joblist;


EXTERN int
mdc_init _AP((void));

EXTERN struct md_arena *
dynd_exec_and_connect _AP((char *host,
			   char *user,
			   struct md_optlist *optlist,
			   struct md_struct **mdStruct,
			   struct dyndState *state,
			   int bufSize));

EXTERN int
dynd_exec _AP((char *host,
	       char *user,
	       struct md_optlist *optlist));

EXTERN struct md_arena *
dynd_connect _AP((char *host,
		  int port,
		  struct md_struct **mdstruct,
		  struct dyndState *state));

EXTERN int
mdc_setopt _AP((struct md_optlist *list,
		char *key,
		char *val));

EXTERN int
dynd_probe _AP((struct md_arena *consumer));

EXTERN int
dynd_next_ts _AP((struct md_arena *consumer,
		  struct dyndState *state));

EXTERN int
dynd_freebuf _AP((struct md_arena *consumer));

EXTERN mdc_proglist_t
mdc_avail_apps _AP((char *host));

EXTERN struct md_optlist *
md_get_usage _AP((char *host,
		  char *prog));

EXTERN mdc_joblist *
mdc_ps _AP((char *host, char *user));

EXTERN int
mdc_cmd_kill _AP((struct md_arena *consumer));

EXTERN int
mdc_cmd_disconnect _AP((struct md_arena *consumer));

EXTERN int
mdc_cmd_rate _AP((struct md_arena *consumer,
		  int rate));

EXTERN int
mdc_cmd_dt _AP((struct md_arena *consumer,
		float dt));

EXTERN int
mdc_cmd_temperature _AP((struct md_arena *consumer,
			 float temperature));

EXTERN int
mdc_proglist_dealloc _AP((mdc_proglist_t proglist));

EXTERN int
mdc_optlist_dealloc _AP((md_optlist *optlist));

EXTERN int
mdc_joblist_dealloc _AP((mdc_joblist *joblist));

EXTERN int
mdc_arena_dealloc _AP((struct md_arena *arena));

EXTERN int
mdc_struct_dealloc _AP((struct md_struct *str));

/* ----------------------------- */
/* MDCOMM Application Routines   */
/* ----------------------------- */

EXTERN mdc_app_arena *
mdc_app_setup _AP((int (*staticFunc)(mdc_app_arena *arena),
                   int (*dynamicFunc)(mdc_app_arena *arena)));

EXTERN int
mdc_app_init _AP((mdc_app_arena *arena));

EXTERN int
mdc_app_update_client _AP((mdc_app_arena *arena, int more));

EXTERN int
mdc_app_set_handler _AP((mdc_app_arena *arena,
                         int tag,
                         int (*handler)(mdc_app_arena *arena)));

EXTERN int 
mdc_app_process_events _AP((mdc_app_arena *arena));

EXTERN int
mdc_app_exit _AP((mdc_app_arena *arena));

EXTERN int
mdc_app_send _AP((mdc_app_arena *arena,
		  void *ubuf,
		  mdc_datatype_t type,
		  int count,
		  int tag));

EXTERN int 
mdc_app_recv _AP((mdc_app_arena *arena,
		  void *buf,
		  mdc_datatype_t type,
		  int count,
		  int tag));
