/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Buttons.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1994/11/08 09:12:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Base class for button type inputs which are associated with a tracker/
 * sensor pair.  Also includes two derived classes, KbdButtons (for keyboard
 * entry with the F keys) and CaveButtons (for input from the Cave).
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Buttons.C,v $
 * Revision 1.5  1994/11/08  09:12:15  dalke
 * set up CaveButtons correctly
 *
 * Revision 1.4  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.3  1994/09/25  22:37:56  billh
 * Changed cave include path, and put in check for VMDCAVE define.
 *
 * Revision 1.2  1994/09/17  10:53:18  dalke
 * added RCS header
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/Buttons.C,v 1.5 1994/11/08 09:12:15 dalke Exp $";
#endif

#include <gl/gl.h>
#include <gl/device.h>
#include <string.h>
#include "Buttons.h"

#ifdef VMDCAVE
#include "cave.h"
#endif

// Looks at the keyboard to update button info.
// There are three allowed "banks" of input, bank
// 0 consists of "F1 F2 F3", bank 1 of "F5 F6 F7"
// and bank 2, "F9 F10 F11".  
//   This reads in from the appropriate bank,
// figures out which buttons changed, and updates
// everything appropriately
void KbdButtons::check_event(void)
{
  memcpy(tmp_state, state, num()*sizeof(float)); // save prev state
  
                                 // get the current button state
  switch(my_bank) {
    case 0:
       state[0] = getbutton(F1KEY) ? TRUE : FALSE;
       state[1] = getbutton(F2KEY) ? TRUE : FALSE;
       state[2] = getbutton(F3KEY) ? TRUE : FALSE;
       break;
    case 1:
       state[0] = getbutton(F5KEY) ? TRUE : FALSE;
       state[1] = getbutton(F6KEY) ? TRUE : FALSE;
       state[2] = getbutton(F7KEY) ? TRUE : FALSE;
       break;
    case 2:
       state[0] = getbutton(F9KEY)  ? TRUE : FALSE;
       state[1] = getbutton(F10KEY) ? TRUE : FALSE;
       state[2] = getbutton(F11KEY) ? TRUE : FALSE;
       break;
    default: 
       state[0] = state[1] = state[2] = FALSE;
       changes[0] = changes[1] = changes[2] = FALSE;
       has_changed = FALSE;
       return ;
  }
  
  // now see who has changed
  has_changed = FALSE;
  for (int i=2; i>=0; i--)
     // something has changed if the current state isn't like the last one
    has_changed = has_changed || 
                  ((changes[i] = state[i] - tmp_state[i] )!=0);
}

#ifdef VMDCAVE
// Looks at the CAVE hardware to get the button presses
void CaveButtons::check_event(void)
{
  memcpy(tmp_state, state, num()*sizeof(float)); // save prev state
  state[0] = CAVEBUTTON1;
  state[1] = CAVEBUTTON2;
  state[2] = CAVEBUTTON3;
   // now see who has changed
  has_changed = FALSE;
  for (int i=2; i>=0; i--)
     // something has changed if the current state isn't like the last one
    has_changed = has_changed || 
                  ((changes[i] = state[i] - tmp_state[i] )!=0);
}
#endif  
