// routines to get memory from and return memory to the 
// CAVE shared memory arena

#include <malloc.h>

// extern void *shared_CAVE_memory_arena;

// use the already alloced memory as the memory arena
// source, and amalloc from it
void *malloc_from_CAVE_memory(size_t size);

// return shared memory to the arena
void free_to_CAVE_memory(void *data);

// get a large chunk of memory from the CAVE and
// remember it for future use
void grab_CAVE_memory(int megs);  


// global routines which call the Scene from the CAVE


// set up the graphics, called from CAVEInitApplication
// doesn't do anything
void cave_gl_init_fn(void);

// return the number of cave render processes
// it does: return CAVEConfig->ActiveWalls
int CAVENumRenderProcesses(void);

// clear the screen, if the frame just started
void cave_clear_screen(void);

// call the renderer
// For the first call this just counts the number of
// drawing processes which were started
void cave_renderer(void);

// wait until all the render processes have finished
void cave_block(void);
