/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveScene.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1994/11/10 17:02:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   The CAVE specific Scene.  It has to get information from the
 * shared memory arena, since the display lists are shared amoung
 * the different machines
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CaveScene.h,v $
 * Revision 1.5  1994/11/10  17:02:35  billh
 * Removed Semaphore.h include; .C includes Inform header.
 *
 * Revision 1.4  1994/11/09  22:40:01  dalke
 * Added blocks for rendering procs.
 *
 * Revision 1.3  1994/11/09  05:20:45  dalke
 * moved functions to their "proper" virtual functions
 *
 * Revision 1.2  1994/11/08  06:35:57  dalke
 * Alpha works with newest CAVE library and new CaveScene
 *
 ***************************************************************************/
#ifndef CAVE_SCENE_H
#define CAVE_SCENE_H

#include "Scene.h"
#include "CaveResizeArray.h"
#include "cave.h"

// This needs to grab shared memory for use in the CAVE
// environment.  It does it with two means.
//  1) use a CaveScane::operator new so that the internal
//      scene information is shared (get_disp_storage and
//      free_disp_storage)
//  2) Give the Resizeable lists a pointer to a function
//      from which to request memory
// The shared memory is allocated through a global function,
//  new_from_CAVE_memory.
// This must also call the left eye and right eye draws correctly

class CaveScene : public Scene {
private:
  // 2D and 3D Displayable objects this Scene is managing
  CaveResizeArray<Displayable *> dispObjList2D;
  CaveResizeArray<Displayable *> dispObjList3D;

  // command lists we are managing
  CaveResizeArray<char *> cmdListArray2D;
  CaveResizeArray<char *> cmdListArray3D;
  
  // number of 2D and 3D Displayable objects this Scene is managing
  // this has to be passed via shared memory
  int *cave_numDisplayable2D, *cave_numDisplayable3D;

  // number of 2D and 3D display lists this Scene is managing
  // this has to be passed via shared memory
  int *cave_num_disp_list2D, *cave_num_disp_list3D;

  // We have to block the parent until all the children are done.
  // To go faster, we should put this into the display lists,
  // and signal when each one can be drawn -- I'll do that sometime
  // later.  For now I keep a simple count.  When it is -1
  // the parent is making the data.  When set to 0, the children
  // should render, when they are finished, they add one.
  // Then the parent can start all over again when the number
  // equals the number of rendering processes
  //  This count is initially set in the constructor

  int *draw_flags;  // tells each rendering child to go

public:
  CaveScene(void);
  virtual ~CaveScene(void);
  
  // called by the CAVE display function call
  // this sets up the correct local variables,
  // then calls the draw in the parent
  void draw(DisplayDevice *);

  
  // call the parent's prepare, then update the shared memory info
  virtual void prepare(DisplayDevice *);

  //
  // virtual routines to access the specific displayable's and lists
  //
  
  // return the Nth Displayable, for the given dim (2 or 3)
  virtual Displayable *displayable2D(int);
  virtual Displayable *displayable3D(int);
 
  // return the Nth display command list, for the given dim (2 or 3)
  virtual char *disp_list2D(int n);
  virtual char *disp_list3D(int n);
  
  //
  // deal with command list storage, and registration of Displayables
  //
  
  // (un)register the given Displayable & corresponding display list (of dim D)
  virtual void Register(Displayable *, char *, int);
  virtual void unRegister(Displayable *, char *, int);

  
  // use our own function to get/free disp_storage
  virtual char *get_disp_storage(int size) ;
  
  virtual void free_disp_storage(char *displist);
  
  // and that should be all she wrote on this end
};
#endif /* CAVE_SCENE_H */
