/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveTracker.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/11/08 09:12:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A CaveTracker is a device for measuring the 3D spacial position of the
 * Cave input device; it is a subclass of the Tracker class.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CaveTracker.h,v $
 * Revision 1.1  1994/11/08  09:12:12  dalke
 * Initial revision
 *
 * Revision 1.1  1994/09/03  11:18:18  dalke
 * Initial revision
 *
 * Revision 1.4  1994/04/20  23:08:33  billh
 * Fixed RCS header in files to include description; set most files to
 * include Global.h, and not ever main.h.  Global.h includes config.h and
 * utilities.h automatically, as well as Message.h for the output message
 * objects.
 *
 * Revision 1.3  1994/04/16  00:36:33  billh
 * Changed program name to vmd, added RCS header section.
 *
 ***************************************************************************/

#ifndef CAVETRACKER_H
#define CAVETRACKER_H
// project include files
#include "Tracker.h"
#include "cave.h"

class CaveTracker : public Tracker {

protected:
  // virtual routine which reads data from sensors, if available
  // returns TRUE if data read and variables changed, FALSE otherwise;
  virtual int my_get_data(int, float *, float *, float *, float *, int);

public:
  // constructors and destructors
  CaveTracker(char *name, int num_sensors = 1);
  virtual ~CaveTracker(void);

};

#endif
