/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdColor.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1994/12/06 08:36:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for affecting molecules.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdColor.h,v $
 * Revision 1.1  1994/12/06  08:36:55  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDCOLOR_H
#define CMDCOLOR_H

#include "Command.h"

// the following defines commands for the Cmdtypes:
// COLOR_NAME, COLOR_CHANGE, COLOR_SCALE_METHOD, COLOR_SCALE_MIDPOINT,
// COLOR_SCALE_MIN, COLOR_SCALE_MAX


//////////////////  utility routines
// given a string which is either a color name or number, return regular
// color index.  If error, return < 0 and print message.
int find_color_index(char *);


//////////////////  commands

///////////////  change the color index for a specifed name in a specified
///////////////  category
class CmdColorName : public Command {
public:
  // index of color category to use in 'colors'; if < 0, error
  int colCatIndex;
  
  // index of color name in specified category; if < 0, error
  int colNameIndex;
  
  // new color to assign to name; if < 0, print color out
  int newColor;

protected:
  virtual int do_execute(void) ;

public:
  // constructor: category name, item name, new color
  CmdColorName(char *, char *, char *, int newUIid=(-1)) ;
};


///////////////  change the rgb settings for a specified color
class CmdColorChange : public Command {
public:
  // color to change; if < 0, error
  int colIndex;
  
  // use given RGB values? if FALSE, use values for given color instead
  int useRGB;
  float newR, newG, newB;
  int newColIndex;

  // instead, do we set the default value?
  int setDefault;

protected:
  virtual int do_execute(void) ;

public:
  // constructor 1: color name, R, G, B
  CmdColorChange(char *, float, float, float, int newUIid=(-1)) ;
  
  // constructor 2: color name, color to use for settings
  CmdColorChange(char *, char *, int newUIid=(-1));
  
  // constructor 3: color name, nothing else ... resets color to
  // build-in default value
  CmdColorChange(char *, int newUIid=(-1));
};


///////////////  change the method used to calculate the color scale
class CmdColorScaleMethod : public Command {
private:
  // new method
  int newMethod;
  
protected:
  virtual int do_execute(void) ;

public:
  // constructor: new method
  CmdColorScaleMethod(int, int newUIid=(-1));
};


///////////////  change the midpoint of the color scale
class CmdColorScaleMidpoint : public Command {
private:
  // new value
  float newval;
  
protected:
  virtual int do_execute(void) ;

public:
  // constructor: new value
  CmdColorScaleMidpoint(float, int newUIid=(-1));
};


///////////////  change the minimum color of the color scale range
class CmdColorScaleMin : public Command {
private:
  // new value
  float newval;
  
protected:
  virtual int do_execute(void) ;

public:
  // constructor: new value
  CmdColorScaleMin(float, int newUIid=(-1));
};


///////////////  change the maximum color of the color scale range
class CmdColorScaleMax : public Command {
private:
  // new value
  float newval;
  
protected:
  virtual int do_execute(void) ;

public:
  // constructor: new value
  CmdColorScaleMax(float, int newUIid=(-1));
};


#endif
