/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdExternal.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/22 08:55:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Turn the UIExternal either on or off
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdExternal.h,v $
 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDEXTERNAL_H
#define CMDEXTERNAL_H

#include "Command.h"
#include "UIExternal.h"

// The following use "EXTERNAL_START" and "EXTERNAL_END"

class CmdExternalStart : public Command {
 protected:
   virtual int do_execute(void) { 
#ifdef VMDEXTERNAL
      return uiExternal -> start_listening();
#else
      msgErr << "vmd not compiled for external PVM input" << sendmsg;
      return FALSE;
#endif 
   }
 public:
   CmdExternalStart(int fromUIid = -1)
   : Command(Command::EXTERNAL_START, fromUIid) {
      *cmdText << "external start" << ends;
   }
   virtual ~CmdExternalStart(void) { }
};

class CmdExternalEnd : public Command {
 protected:
   virtual int do_execute(void) { 
#ifdef VMDEXTERNAL
      return uiExternal -> stop_listening();
#else
      msgErr << "vmd not compiled for external PVM input" << sendmsg;
      return FALSE;
#endif
   }
 public:
   CmdExternalEnd(int fromUIid = -1)
   : Command(Command::EXTERNAL_END, fromUIid) {
      *cmdText << "external end" << ends;
   }
   virtual ~CmdExternalEnd(void) { }
};


#endif
