/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/11/24 07:26:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdRender.h,v $
 * Revision 1.1  1994/11/24  07:26:41  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef CMDRENDER_H
#define CMDRENDER_H
// the following uses only the Cmdtypes RENDER and RENDERLIST

#include "Command.h"
#include "Global.h"
#include "Scene.h"
#include "DisplayDevice.h"

// render the global scene
class CmdRender : public Command {
public:
  Scene *sc;     // this is here for the time in the future when we have
                 // multiple scenes
  DisplayDevice *display;  // ditto, for DisplayDevices (there's only one now)
  char *filename;
  char *method;  // what kind of output?  "postscript", "rayshade", etc.
protected:
  virtual int do_execute(void) {
    return sc -> filedraw(method, filename, display);
  }
  
public:
  CmdRender(char *newmethod, char *newfilename, int id=(-1))
      : Command(Command::RENDER, id) {
    sc = scene;           // get the global scene
    display = ::display;  // ditto for disp. dev.
    filename = stringdup(newfilename);
    method = stringdup(newmethod);
    // make the text needed for the log output
    *cmdText << "render " << newmethod << " " << newfilename << ends;
  }

  virtual ~CmdRender(void) {
    delete [] filename;
    delete [] method;
  }
};

// list the available rendering types
class CmdRenderList : public Command {
protected:
  virtual int do_execute(void) {
//   if (fileRenderList.num() == 0) {
     msgInfo << "Bummer, there are no possible output formats." << sendmsg;
//   } else {
//     msgInfo << "The valid output formats are:" << sendmsg;
//     for (int i=0; i<fileRenderList.num(); i++) {
//       msgInfo << i+1 << "  " << renderList.name(i) << sendmsg;
//     }
//   }
   return TRUE;
  }
public:
  CmdRenderList(int id=(-1)) : Command(Command::RENDERLIST, id) {
  }
  virtual ~CmdRenderList(void) {
  }
};



#endif
