/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTracker.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/09/15 07:04:49 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the various tracker commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdTracker.C,v $
 * Revision 1.1  1994/09/15  07:04:49  dalke
 * Initial revision
 *
 ****************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/CmdTracker.C,v 1.1 1994/09/15 07:04:49 dalke Exp $";
#endif

#include "Global.h"
#include "CmdTracker.h"
// list the available trackers, sends to msgInfo
int CmdTrackerListAvail::do_execute(void)
{
      int i = trackerList -> num_avail();
      if (i==0) {
	msgInfo << "  No trackers are available." << sendmsg;
      } else {
	msgInfo << "Available trackers:\n" << sendmsg;
	for (int j=0; j<i; j++)
          msgInfo << " " << j+1 << "   " << trackerList -> 
                        avail_name(j) << '\n' << sendmsg;
      }
  return TRUE;
}

// list the trackers, sends to msgInfo
int CmdTrackerList::do_execute(void)
{
      int i = trackerList -> num();
      if (i == 0 ) {
	msgInfo << "  No trackers are running.\n" << sendmsg;
      } else {
	msgInfo << "Running trackers:\n" << sendmsg;
	for (int j=0; j<i; j++) {
          msgInfo << " " << j+1;
          if (trackerList->tracker(j)->paused())
            msgInfo << " (paused) ";
           else
            msgInfo << "          ";
          msgInfo  << trackerList -> name(j) << '\n' << sendmsg;
	}
      }
  return TRUE;
}

// return the current location (x,y,z) of a tracker/sensor pair
int CmdTrackerLoc::do_execute(void)
{
  float x,y,z;
  trackerList -> tracker(trackernum) -> get_position
     (sensornum, x, y, z);
  msgInfo << "Tracker: " << trackernum+1 << "  Sensor: " 
           << sensornum+1 << sendmsg;
  msgInfo << "x= " << x << " y= " << y << " z= "<< z << sendmsg;
  return TRUE;
}
