/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ConfigList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1994/11/02 06:58:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read in a configuration file of the form:
 *       keyword = information\n
 *-or-   keyword information\n
 * and produces a database which can return a string (char *)
 * associated with that keyword.  Multiple files can be read.
 * 
 *    A "word" is a seqeunce of characters that are not white space (see
 * isspace(3C) ).  The equals sign ('=') is optional (though if there is more
 * more than one equals sign, then the 2nd is not ignored).  The "information"
 * field may contain more than one word.  White space is ignored except that
 * white space between multiple words in the information field is maintained.
 * Everything on the line at and beyond a pound sign ('#') is ignored.  Hence
 * a data file can be:
 *   fullname = George   Washington # the first president of the U.S.
 *   fullname = Martha Washington   # his second wife
 * Once that is read in, all data associated with "name" can be retreived as
 *  StringList *strList = configFile.find("fullname");
 *  for (StringList *tmp=strList; tmp!=NULL; tmp = tmp -> next)
 *      cout << tmp->data << '\n';
 * Note:
 *   The returned StringList * is NOT new'ed.  Do NOT free it.
 *   Keywords are case INsensitive
 *   In this version of ConfigList, only ONE keyword/data pair is kept,
 * the last one read.  All previous ones are deleted.
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ConfigList.h,v $
 * Revision 1.2  1994/11/02  06:58:32  billh
 * Fixed small problem with comment header.
 *
 * Revision 1.1  1994/11/02  05:17:53  dalke
 * Initial revision
 *
 *
 * Taken from namd's ConfigList.h version 1.2
 * 
 ***************************************************************************/

// This header introduces two names to the global name space
// They are:
//    StringList -- a linked list of char *.  It has an initilizer and
//      destructor to handle the char * by alloc'ing new space
//    ConfigList -- its constructor opens a file containing lines of the
//      format "keyword = data" and creates a listing of all the data
//      for each keyword.  This data can be retreived with "find(char *)"

#ifndef CONFIGLIST_H
#define CONFIGLIST_H
#include "Inform.h"
#include "Global.h"
#include <string.h>

typedef struct StringList {
  char *data;
  StringList *next;
  StringList(char *newdata) {  // take a string, and copy it
     data = new char[strlen(newdata)+1];
     strcpy( data, newdata);
     next = NULL;
  }
  ~StringList( void) {  // just clear out my info
    delete [] data;
    data = NULL;
    next = NULL;
  }
} StringList;

class ConfigList {
  private:
    typedef struct ConfigListNode {
      char *name;
      StringList *data;
      ConfigListNode *next;
      ConfigListNode( ConfigListNode *newnext, char *newname, 
                                          StringList *newdata) {
        name = new char[strlen(newname)+1];  // create space for the name
        strcpy((char *) name, newname);      // and copy the new name
        data = newdata;
        next = newnext;
      }
      ~ConfigListNode( void) {
        delete [] name;                  // delete the new'ed name
        name = NULL;
        next = NULL;
        StringList *curr, *next;        // go through the string list
        for (curr= data; curr!=NULL; curr = next) {
          next = curr -> next;           // and delete each element
          delete curr;
        }
      }
    } ConfigListNode;
    
    ConfigListNode *theList;
       // copy the information into a String, as appropriate
    void add_element( char *s1, int len1, char *s2, int len2);
    ConfigListNode *find_key_word( const char *keyword);
  public:
    ConfigList( void);
    ~ConfigList( void);
    int read( const char *filename);       // read a file for keywords
//    StringList *find( const char *name);   //search for values by name
    char *find( const char *name);   //search for values by name
       // NOTE: do not change or delete this information.  It is not new'ed
       //   and any changed you make will be permanent.
       
    ConfigListNode *head( void) { return theList;  } // return everything
       // NOTE:  you _REALLY_ not not want to change the information
       //   you get from this (unless you really want to)
};


#endif // CONFIGLIST_H
