/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAngle.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between three atoms, and draws a marker for the angle
 * into the display list for a given Displayable.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryAngle.h,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GEOMETRYANGLE_H
#define GEOMETRYANGLE_H

#include "GeometryMol.h"


class GeometryAngle : public GeometryMol {

public:
  // constructor: molecule id's, atom indices, molecule list
  GeometryAngle(int *, int *, MoleculeList *);
  
  //
  // public virtual routines
  //
  
  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

};

#endif
