/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAtom.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Draws a marker for a specified atom into the display list for a Displayable
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryAtom.C,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/GeometryAtom.C,v 1.1 1995/03/04 05:33:08 billh Exp $";
#endif

#include "GeometryAtom.h"
#include "MoleculeList.h"
#include "Molecule.h"


////////////////////////  constructor  /////////////////////////
GeometryAtom::GeometryAtom(int m, int a, MoleculeList *mlist)
	: GeometryMol(1, &m, &a, mlist) {

  // indicate this object does not have a value
  hasValue = FALSE;
}



////////////////////  public virtual routines  //////////////////////

// draw the geometry marker in the given Displayable's drawing list
void GeometryAtom::draw_marker(Displayable *d) {

  // get the molecule pointer and atom position
  Molecule *mol = transformed_atom_coord(objIndex[0], comIndex[0], valuePos);
  
  // do not draw if illegal molecule, or atom is not on
  if(!mol)
    return;

  // everything is OK, draw text at atom position
  display_string(mol->atom_full_name(comIndex[0]), d);
}
