/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryBond.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between two atoms, and draws a marker for the bond
 * into the display list for a given Displayable.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryBond.C,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/GeometryBond.C,v 1.1 1995/03/04 05:33:08 billh Exp $";
#endif

#include "GeometryBond.h"
#include "MoleculeList.h"
#include "Molecule.h"
#include "utilities.h"


////////////////////////  constructor  /////////////////////////
GeometryBond::GeometryBond(int *m, int *a, MoleculeList *mlist)
	: GeometryMol(2, m, a, mlist) {

}



////////////////////  public virtual routines  //////////////////////

// recalculate the value of this geometry, and return it
float GeometryBond::calculate(void) {

  // get coords to calculate distance 
  float pos1[3], pos2[3];
  if(!normal_atom_coord(objIndex[0], comIndex[0], pos1))
    return 0.0;
  if(!normal_atom_coord(objIndex[1], comIndex[1], pos2))
    return 0.0;

  subtract(pos2, pos2, pos1);
  return(geomValue = norm(pos2));
}


// draw the geometry marker in the given Displayable's drawing list
void GeometryBond::draw_marker(Displayable *d) {
  char valbuf[32];

  // get the transformed positions, and draw a line between them
  float pos1[3], pos2[3];
  if(!transformed_atom_coord(objIndex[0], comIndex[0], pos1))
    return;
  if(!transformed_atom_coord(objIndex[1], comIndex[1], pos2))
    return;

  // draw a line into the given Displayable
  display_line(pos1, pos2, d);
  
  // print value of distance at midpoint
  midpoint(valuePos, pos1, pos2);
  sprintf(valbuf, "%7.2f", geomValue);
  display_string(valbuf, d);
}
