/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GeometryFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu for working with the graphical geometry monitors.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryFormsObj.h,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef GEOMETRYFORMSOBJ_H
#define GEOMETRYFORMSOBJ_H

#include "FormsObj.h"


class GeometryFormsObj : public FormsObj {

private:
  // fill the geometry name browser with the current geometry marker names
  void fill_geometry_browser(void);
  
protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  GeometryFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);
  virtual ~GeometryFormsObj(void) { }

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif
