/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Global.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.14 $	$Date: 1995/03/04 05:13:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Global data structures, configuration settings, and macros for the 
 * vmd library.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Global.h,v $
 * Revision 1.14  1995/03/04  05:13:15  billh
 * Added geometry menu.
 *
 * Revision 1.13  1995/02/22  08:43:51  dalke
 * added uiExternal
 *
 * Revision 1.12  1994/11/24  07:27:03  dalke
 * Added fileRenderList
 *
 * Revision 1.11  1994/11/02  05:18:27  dalke
 * Added configList read from .vmd_init files
 * Added configList option to turn off the title
 *
 * Revision 1.10  1994/10/28  18:36:05  billh
 * Updated due to conversion of Mouse to a general base class.  Window
 * events have also been made non-GL-specific.
 *
 * Revision 1.9  1994/10/21  03:49:55  billh
 * Added remoteList global variable, and sim control menu.
 *
 * Revision 1.8  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.7  1994/10/01  03:09:18  billh
 * Improved setup of compiler directives.  Now the VMDFORMS define also
 * refers to using a GLDisplayDevice.  Also, Mouse object only defined
 * and used if VMDFORMS is defined.
 *
 * Revision 1.6  94/09/30  23:26:41  billh
 * Added remote object reference; soon to add Files menu.
 * 
 * Revision 1.5  1994/09/17  10:08:12  dalke
 * moved trakerList to UIVR, added uiVR
 *
 * Revision 1.4  1994/09/17  09:02:48  billh
 * Put in moleculeList object, and code to create it.
 *
 * Revision 1.3  1994/09/07  07:48:07  dalke
 * added trackerList
 *
 * Revision 1.2  1994/09/06  03:40:56  billh
 * Added code to parse command-line options, and to read init file and
 * startup file (init file processing must still be added).
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GLOBAL_DEFS_H
#define GLOBAL_DEFS_H

// standard includes for all modules
#include "utilities.h"
#include "config.h"
#include "Inform.h"

// the name of this program
extern char *myName;
extern char *myPath;

// display device in which the images are rendered
extern class DisplayDevice;
extern DisplayDevice *display;

// the list of all Displayable objects to draw
extern class Scene;
extern Scene *scene;

// the list of all Lights which should be drawn
extern class LightList;
extern LightList *lights;

// the list of all color objects (including material definitions)
extern class ColorList;
extern ColorList *colors;

// axes and stage used in the scene
extern class Axes;
extern Axes *axes;
extern class Stage;
extern Stage *stage;

// the command processor
extern class CommandQueue;
extern CommandQueue *commandQueue;

// collection of all user interface objects
extern class UIList;
extern UIList *uiList;

// the text interface
extern class UIText;
extern UIText *uiText;

// the mouse used to manipulate the objects
extern class Mouse;
extern Mouse *mouse;

// the global lists of all tools and trackers in maintained in UIVR
extern class UIVR;
extern UIVR *uiVR;

// the global list of all molecules
extern class MoleculeList;
extern MoleculeList *moleculeList;

// the global list of geometry labels
extern class GeometryList;
extern GeometryList *geometryList;

// current remote setup object (only one is active at a time), and list of
// running simulations
#ifdef VMDREMOTE
extern class Remote;
extern Remote *remote;
extern class RemoteList;
extern RemoteList *remoteList;
#endif

// resource to hold configuration values from a file
extern class ConfigList;
extern ConfigList *configList;

// the different ways to record a scene to a file in some format
extern class FileRenderList;
extern FileRenderList *fileRenderList;

// this allow text commands to be sent in via PVM messages
extern class UIExternal;
extern UIExternal *uiExternal;

/////////////////////////  external functions  

// initialize the global variables and objects for the general library.
// Must be passed command-line arguments to program.  Creates graphics
// context and all associated objects, and then starts the UI, then adds any
// commands that should be done at start.  When done, flushes command queue
// and then returns, when the program is ready to start main event loop.
extern void VMDinit(int, char *[]);

// initialize the user interface ... called by VMDinit at start
extern void VMDinitUI(void);

// reads the definitions in the given init file at program start.
// arguments are default path, and filename.
extern void VMDreadInit(char *, char *);

// sets text interface to read in the commands in the given file at startup
// arguments are default path, and filename.
extern void VMDreadStartup(ConfigList *, char *, char *);

// print out title message
extern void VMDtitle(void);

// redraw the screen and update all things that need updatin'
extern int VMDupdate(int);

// exit the program normally with a message and exit code
extern void VMDexit(char *, int);

// exit the program abnormally with a message
extern void VMDdie(char *);

#endif
