/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GrabTool.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/11/03 12:24:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   This type of Tool can be used to pick up and manipulate molecules.
 * Just press button 0 to pick it up, and again to put it down
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GrabTool.h,v $
 * Revision 1.1  1994/11/03  12:24:17  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifndef GRABTOOL_H
#define GRABTOOL_H
// Simple grabbing tool, derived from Tool
// Draw a representation as a cylinder with silver cylindrival tip
//  (supposed to be like a bar magnet)
// Use button 0 to grab onto the active molecules
// press again to release it

#include "Tool.h"

class GrabTool : public Tool {
public:

private:
  // draw a cylinder with the given number of sides.
  // because of the graphics transformations already
  // done, I can assume the base is at (0,0,0) and the
  // tip is at (1,0,0).
  void draw_cylindrical_pointer(ToolInfo *info, int numsides);
  int grabbed;
  float x, y, z;
 
public:
  GrabTool(char *name, Scene *sc, int drawlist_size = 2) 
     : Tool(name, sc, drawlist_size) {
    tip_checking = FULL;
    grabbed = FALSE;
  }
  virtual ~GrabTool(void) {
  }
  virtual void tool_event(ToolControl *toolctrl, ToolInfo *info);
  virtual void redraw_list(ToolInfo *info);
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);
  
};

#endif
