/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GraphicsFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/12/05 08:24:43 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the coloring and display method of molecules.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GraphicsFormsObj.h,v $
 * Revision 1.3  1994/12/05  08:24:43  billh
 * Added multiple modes for changing reps; now includes second mode to
 * use the mouse to select atoms, with a browser for looking at the molecule
 * names.
 *
 * Revision 1.2  94/10/31  20:32:01  billh
 * Fixed many bugs, set to always modify when something changes.
 * 
 * Revision 1.1  1994/10/29  01:34:41  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GRAPHICSFORMSOBJ_H
#define GRAPHICSFORMSOBJ_H

#include "FormsObj.h"
#include "Molecule.h"


class GraphicsFormsObj : public FormsObj {

private:
  // which molecule ID we are working with, and pointer to this molecule
  int molID;
  Molecule *dmol;
  
  // which representation of the current molecule is being edited. If < 0,
  // none are.  If more than one is being editing, this is the smallest
  // number in the list.
  int molRep;

  // current mode of editing for the menu ...
  int editMode;

  // fill the given string buffer with a string describing the mth rep of
  // the current mol.  Returns a pointer to the string.  If error, string is
  // returned empty.
  char *graphics_rep_string(int m, char *);
  
  // set the graphics editing mode to the given value
  void set_editing_mode(int);

  // fill the namelist browser for atom selection with the proper names
  void reset_namelist_browser(void);

  // fill the graphics rep browser with the settings for the current mol
  void fill_graphics_reps_browser(void);

  // reset the form to use the molecule with given ID as the current mol
  void reset_edited_molecule(int);
  
  // reset the form based on the current selections in the graphics rep browser
  void reset_edited_rep(void);

  // reset coloring method controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_coloring_method(int);
  
  // reset drawing method controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_drawing_method(int);
  
  // reset atom selection controls based on current rep, if any
  // Argument is a flag for whether the values of the data items should be
  // changed.
  void reset_selection_method(int);

  // fill string with text command to set objects to proper color, rep, or sel
  char *create_color_cmd(void);
  char *create_rep_cmd(void);
  char *create_sel_cmd(void);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  GraphicsFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);
  virtual ~GraphicsFormsObj(void) { }

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

  // update the interface display for each screen redraw
  // NOT NEEDED HERE.
  // virtual void update(void);

};

#endif
