/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.C,v $
 *	$Author: billh $	$Locker: billh $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 94/08/24 03:10:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	LightList.C,v $
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX
  static char ident[] = "@(#)$Header: /private/Net/cairo/usr/local/src/vmd_new/billh/src/RCS/LightList.C,v 1.1 94/08/24 03:10:37 billh Exp Locker: billh $";
#endif

#include "LightList.h"
#include "Scene.h"
#include "DisplayDevice.h"
#include "Inform.h"

// default light data
static float def_light_color[3] = { 1.0, 1.0, 1.0 };
static float def_light_pos[DISP_LIGHTS][3] = { 
	{ -0.1, 0.1, 1.0 }, { 1.0, 2.0, 0.5 },
	{ -1.0, 2.0, -1.0 }, { -1.0, -1.0, 0.0 }
};


// constructor: create lights with default values, and add to self
LightList::LightList(Scene *sc, ColorList *collist) {

  MSGDEBUG(1,"Creating LightList, with " << DISP_LIGHTS << " lights.");
  MSGDEBUG(1,sendmsg);

  // create lights, with default values, and tell to use given colorlist
  for(int i=0; i < DISP_LIGHTS; i++) {
    append(new Light(sc, i, def_light_color, def_light_pos[i]));
    if(collist)
      (item(num() - 1))->use_colors(collist);
  }

  // make light 0 the current light
  reset();
}


// destructor: delete lights in list
LightList::~LightList(void) {
  MSGDEBUG(1,"Deleting LightList, with " << DISP_LIGHTS << " lights.");
  MSGDEBUG(1,sendmsg);

  reset();
  for(int i=0; i < DISP_LIGHTS; i++)
    delete get();
}


// apply rotations to the current light, if any
void LightList::add_rot(float x, char axis) {
  if(!is_current())
    return;
    
  current() ->add_rotation(x, axis);
}

// apply rotations to the current light, if any
void LightList::add_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->add_rotation(m);
}

// apply rotations to the current light, if any
void LightList::set_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->set_rotation(m);
}

