/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFile.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/02/12 07:21:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeFile is inherited from Molecule, and supplies routines to 
 * create a molecule by reading data from a file.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFile.h,v $
 * Revision 1.4  1995/02/12  07:21:11  dalke
 * moved PDB and PSF reads into seperate objects, making a "Molecule"
 * be much more general.
 *
 * Revision 1.3  1994/11/22  02:35:19  billh
 * Changed to not require StructureFile enum as type of argument to constructor.
 *
 * Revision 1.2  94/09/30  05:36:18  billh
 * Added externally-available string arrays for file type extensions.
 * 
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef MOLECULEFILE_H
#define MOLECULEFILE_H

#include "Molecule.h"
#include "ReadEDM.h"

class MoleculeFile : public Molecule {

public:
  // ways to read structure ... character names are in the array declared
  // at the bottom of this file.
  enum StructureFile { PSF, PDB, EDM, GRAPH, RASTER3D,
     STRTYPES, UNKNOWN };

protected:
  // name of path and filename containing structure of molecule
  char *strFile, *strPath;
  // name of this molecule
  char *strName;

  // blank filename
  char blankname[1];

  // this extracts the filename
  // and inits some data
  void do_construct(char *filename);

public:
  //  class constructor/destructor
  MoleculeFile(char *filename, Scene *);
  MoleculeFile(char *filename, Displayable *);
  virtual ~MoleculeFile(void);

  // creates the molecule, using the info provided in the constructor.
  // returns success, and also calls parent class create routines
  virtual int create(void) {return Molecule::create(); }

  // return the path of this molecule
  virtual char *file_path(void) {
    char *retname;
    if(!strPath)
      retname = blankname;
    else
      retname = strPath;
    return retname;
  }

  // return the name of this molecule
  virtual char *file_name(void) {
    char *retname;
    if(!strName)
      retname = blankname;
    else
      retname = strName;
    return retname;
  }

};

// string names for the different structure file types (identified by
// their file extension)
extern char *structureFileTypeNames[MoleculeFile::STRTYPES];

#endif
