/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePDB.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read the molecule information from a PDB file
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFilePDB.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/


#ifndef MOLECULEFILEPDB_H
#define MOLECULEFILEPDB_H
#include "MoleculeFile.h"

// get the coordinate information, then
// makes the connections using a distance search
class MoleculeFilePDB : public MoleculeFile
{
 private:
  // cutoff distance for reading pdb file
  float pdbCutoff;

  // create the molecular structure based on the given .pdb file
  int createFromPDB(char *pdbfile, float cutoff);

  // determine bonds from position of atoms previously read.
  // If the specified Timestep is NULL, then the coordinates stored in the
  // Atom records will be used.
  int find_bonds_from_coordinates(Timestep *, float);


 public:
// If cutoff < 0, use vdw radius to determine if bonded.
   MoleculeFilePDB(char *filename, Scene *, float cutoff = (-1.0));
   MoleculeFilePDB(char *filename, Displayable *, float cutoff = (-1.0));
   virtual ~MoleculeFilePDB(void);

   // creates the molecule and returns success - also calls
   // the parent class create routines
   virtual int create(void);
};

#endif
