/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePSF.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read the molecule information from a PSF file
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFilePSF.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef MOLECULEFILEPSF_H
#define MOLECULEFILEPSF_H
#include "MoleculeFile.h"

// Note that the reference to:
//  the textual description: in MoleculeFile
//  the constructor: in CmdMol.C
//
class MoleculeFilePSF : public MoleculeFile
{
 private:
  // read in the molecular data from the specified PSF file
  int createFromPSF(char *psffile);

 public:
   MoleculeFilePSF(char *, Scene *);
   MoleculeFilePSF(char *, Displayable *);
   virtual ~MoleculeFilePSF(void);

   // creates the molecule and returns success - also calls
   // the parent class create routines
   virtual int create(void);
};

#endif
