/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileRaster3D.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   read in from a Raster3D data file
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFileRaster3D.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

// All this does is read the data into the rendering command list
// there is no way to change anything -- maybe in the future?

#ifndef MOLECULEFILERaster3D_H
#define MOLECULEFILERaster3D_H
#include "MoleculeFile.h"

class MoleculeFileRaster3D : public MoleculeFile
{
 private:
   // I don't have to save anything since I cannot
   // yet manipulate the objects
   
   float minx, miny, minz, maxx, maxy, maxz;
 public:
   MoleculeFileRaster3D(char *filename, Scene *);
   MoleculeFileRaster3D(char *filename, Displayable *);
   virtual ~MoleculeFileRaster3D(void);

   // create the molecule and calls the parents
   virtual int create(void);
   virtual void create_cmdlist(void) { }; // list is actually made in create

   // center of volume
   virtual void cov(float &x, float &y, float&z) {
      x = (minx + maxx)/2;
      y = (miny + maxy)/2;
      z = (minz + maxz)/2;
   }
   // get the size
   virtual float scale_factor(void) {
      float wx = maxx - minx;
      float wy = maxy - miny;
      float wz = maxz - minz;
      if (wx > wy) {
	 if (wx > wz) {
	    return 2.0/wx;  // the 2.0 is to fit the system in
	 } else {           // a box from -1 to 1
	    return 2.0/wz;
	 }
      } else {
	 if (wy > wz) {
	    return 2.0/wy;
	 } else {
	    return 2.0/wz;
	 }
      }
   }
};

#endif

