/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: NameList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.8 $	$Date: 1995/01/29 19:57:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * NameList object, which stores a list of unique names indexed in the order
 * they are added.  For each name, which acts as a key, there is an associated
 * integer value.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: NameList.h,v $
 * Revision 1.8  1995/01/29  19:57:14  billh
 * Moved almost all in-lined functions to .c file
 *
 * Revision 1.7  94/11/12  10:24:13  dalke
 * fixed up how spaces are deleted
 * 
 * Revision 1.6  1994/11/12  04:04:20  dalke
 * fixed problem with typecode
 *
 * Revision 1.5  1994/11/10  17:20:47  billh
 * Strips leading and trailing spaces from added names.
 *
 * Revision 1.4  94/11/02  01:37:23  billh
 * Added option to search for a name by just the first N characters, via
 * optional 2nd argument to 'name' and 'data'.
 * 
 * Revision 1.3  94/09/24  20:12:57  billh
 * Now a template; this is a basic associative array, with a character
 * string as the main lookup key, and a specified type for the data stored
 * for each name.
 * 
 * Revision 1.2  94/09/23  00:54:55  billh
 * names and Data now ResizeArray objects, instead of using a
 * linked list.  Much nicer, much shorter, and actually works.
 * 
 * Revision 1.1  94/09/17  09:11:36  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef NAMELIST_H
#define NAMELIST_H

#include "ResizeArray.h"

#define NLISTSIZE	64


template<class T>
class NameList  {

protected:
  // array of pointers to the strings; constructed by 'init'
  ResizeArray<char *> names;
  
  // integer data for the items
  ResizeArray<T> Data;

  // indices of names, in increasing sorted order
  ResizeArray<int> sortedOrder;

  // items in the list
  int Num;

public:
  // constructor and destructor
  NameList(void);
  ~NameList(void);

  //
  // query info about this class
  //

  // return number of items
  int num(void) { return Num; }

  //
  // routines for adding or retrieving names
  //

  // add a new name to the list, with a given associated value.
  // Return the index.  If already in the list, return the current index.
  int add_name(char *, const T &);

  // return the name (null-terminated) for given typecode
  char *name(int);

  // return the Nth name in sorted order (instead of order in which added)
  char *sort_name(int);

  //
  // routines for retrieving typecodes
  //

  // return the type index for the given name.  If the second argument is
  // given and is > 0, it is used as the max length of the names to check
  // for a match.  If is is <= 0, an exact match must be found.
  //	returns (-1) if no match is found
  int typecode(char *, int = (-1));

  // returns actual index of name in Nth sorted position
  int sort_typecode(int);

  //
  // routines for changing or retrieving data values
  //

  // returns the data for the given name.  If the second argument is
  // given and is > 0, it is used as the max length of the names to check
  // for a match.  If is is <= 0, an exact match must be found.
  T data(char *, int = (-1));

  // returns the data for the given index
  T data(int);

  // set the data value for the given index
  void set_data(int, const T &);

};

#endif
