/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PointerTool.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/10/04 09:05:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Provides "pointing" ability.  Can point, grow/shrink, change detail
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: PointerTool.h,v $
 * Revision 1.3  1994/10/04  09:05:34  dalke
 * Added button controls for length/size/detail
 *
 ***************************************************************************/
#ifndef POINTERTOOL_H
#define POINTERTOOL_H
// Simple tool, derived from Tool
// Draw a representation as a cylinder with a cone tip
// This tool can grow or shrink in length, size, and detail
// Use button 1 to toggle between those 3 modes
// Use button 0 to grow/shrink (it alternates between the two states)
// Button 2 causes the tip to check for buttons

#include "Tool.h"

class PointerTool : public Tool {
public:
  enum {LENGTH, SCALE, DETAIL };  // different states toggled by button 2
  enum {DECREASE, INCREASE};      // direction of the next button press

private:
  // draw a cylinder with the given number of sides.
  // because of the graphics transformations already
  // done, I can assume the base is at (0,0,0) and the
  // tip is at (1,0,0).
  void draw_cylindrical_pointer(ToolInfo *info, int numsides);
  int modification_state;
  int direction_state;
 
public:
  PointerTool(char *name, Scene *sc, int drawlist_size = 2) 
     : Tool(name, sc, drawlist_size) {
    tip_checking = FULL;
    modification_state = LENGTH;
    direction_state = INCREASE;
  }
  virtual ~PointerTool(void) {
  }
  virtual void tool_event(ToolControl *toolctrl, ToolInfo *info);
  virtual void redraw_list(ToolInfo *info);
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);
  
  int modification(void) { return modification_state; }
  void modification(int newmod) { modification_state = newmod; }
  int direction(void) { return direction_state; }
  void direction(int newdir) { direction_state = newdir; }
};

#endif
