/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadPDB.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/09/17 09:11:36 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General routines to read .pdb files.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ReadPDB.C,v $
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/ReadPDB.C,v 1.1 1994/09/17 09:11:36 billh Exp $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ReadPDB.h"

/* string containing whitespace separator characters for tokenizing	*/
static char separators[3] = {' ', '\t', '\0'};


/* read the next record from the specified pdb file, and put the string found
   in the given string pointer (the caller must provide adequate (81 chars)
   buffer space); return the type of record found
*/
int read_pdb_record(FILE *f, char *retStr) {

  char inbuf[PDB_RECORD_LENGTH+2], inbuf2[PDB_RECORD_LENGTH+2];
  char *tok;
  int recType = PDB_UNKNOWN;
  
  /*	read the next line	*/
  if(inbuf != fgets(inbuf, PDB_RECORD_LENGTH+1, f)) {
    strcpy(retStr,"");
    recType = PDB_EOF;
  } else {
    /*	remove the newline character, if there is one */
    if(inbuf[strlen(inbuf)-1] == '\n')
      inbuf[strlen(inbuf)-1] = '\0';
    strcpy(inbuf2,inbuf);
    tok = strtok(inbuf2,separators);
    if(tok == NULL) {
      recType = PDB_UNKNOWN;
    } else if(strcmp(tok,"REMARK") == 0) {
      recType = PDB_REMARK;
    } else if(strcmp(tok,"ATOM") == 0 || strcmp(tok,"HETATM") == 0) {
      recType = PDB_ATOM;
    } else if(strcmp(tok,"END") == 0) {
      recType = PDB_END;
    }
    if(recType == PDB_REMARK || recType == PDB_ATOM) {
      strcpy(retStr,inbuf);
    } else {
      strcpy(retStr,"");
    }
  }
  
  return recType;
}


/* Extract the x,y, and z coordinates from the given ATOM record.	*/
void get_pdb_coordinates(char *record, float *x, float *y, float *z,
	float *occup, float *beta) {
  char numstr[9];

  /* get X, Y, and Z */
  numstr[8] = '\0';
  strncpy(numstr, record + 30, 8);
  *x = atof(numstr);
  strncpy(numstr, record + 38, 8);
  *y = atof(numstr);
  strncpy(numstr, record + 46, 8);
  *z = atof(numstr);
  strncpy(numstr, record + 54, 6);
  *occup = atof(numstr);
  strncpy(numstr, record + 60, 6);
  *beta = atof(numstr);
}

  
/* Break a pdb ATOM record into it's fields.  The user must provide the
   necessary space to store the atom name, residue name, and segment name.
   Character strings will be null-terminated.  Returns the atom serial number.
*/
int get_pdb_fields(char *record, char *name, char *resname, char *segname, 
   char *resid, float *x, float *y, float *z, float *occup, float *beta) {
  int i,len, num;

  /* get serial number */
  sscanf(record + 6,"%d",&num);

  /* get atom name */
  strncpy(name,record + 12, 4);
  name[4] = '\0';
  while((len = strlen(name)) > 0 && name[len-1] == ' ')
    name[len-1] = '\0';
  while(len > 0 && name[0] == ' ') {
    for(i=0; i < len; i++)  name[i] = name[i+1];
    len--;
  }

  /* get residue name */
  strncpy(resname,record + 17, 3);
  resname[3] = '\0';
  while((len = strlen(resname)) > 0 && resname[len-1] == ' ')
    resname[len-1] = '\0';
  while(len > 0 && resname[0] == ' ') {
    for(i=0; i < len; i++)  resname[i] = resname[i+1];
    len--;
  }

  /* get residue id number */
  strncpy(resid,record + 22, 4);
  resid[4] = '\0';
  while((len = strlen(resid)) > 0 && resid[len-1] == ' ')
    resid[len-1] = '\0';
  while(len > 0 && resid[0] == ' ') {
    for(i=0; i < len; i++)  resid[i] = resid[i+1];
    len--;
  }

  /* get x, y, and z coordinates */
  get_pdb_coordinates(record, x, y, z, occup, beta);

  /* get segment name	*/
  if(strlen(record) >= 73) {
    strncpy(segname, record + 72, 4);
    segname[4] = '\0';
    while((len = strlen(segname)) > 0 && segname[len-1] == ' ')
      segname[len-1] = '\0';
    while(len > 0 && segname[0] == ' ') {
      for(i=0; i < len; i++)  segname[i] = segname[i+1];
      len--;
    }
  } else {
    strcpy(segname,"");
  }
   
  return num;
}  
