/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SimFormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1994/11/21 14:44:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the running simulations.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: SimFormsObj.C,v $
 * Revision 1.4  1994/11/21  14:44:20  billh
 * Bracketed .C and .h files in checks for having VMDREMOTE defined.
 *
 * Revision 1.3  94/11/11  16:32:30  billh
 * Updated how info displayed in sim status browser.
 * 
 * Revision 1.2  94/11/09  02:50:28  billh
 * Added finished support for displaying patches for a remote molecule.
 * 
 * Revision 1.1  94/10/21  03:49:26  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/SimFormsObj.C,v 1.4 1994/11/21 14:44:20 billh Exp $";
#endif

#ifdef VMDREMOTE

#include "SimFormsObj.h"
#include "RemoteList.h"
#include "DrawPatch.h"
#include "CmdRemote.h"
#include "Global.h"
#include "MoleculeRemote.h"

// commands we are interested in
static int numCmds = 5;
static int cmdList[5] = { Command::SIM_SETPARAM, 
	Command::SIM_PATCHDISP, 	Command::SIM_TOP,
	Command::SIM_DETACH,		Command::SIM_KILL };


/////////////////////////  constructor  
SimFormsObj::SimFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("sim", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = simMenu;
  lightButton = sim_menu_button;
  offButton = sim_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();

  editParam = (-1);
}

/////////////////////////  private routines  

// reset the selection browser
void SimFormsObj::reset_sim_selection(void) {
  freeze();
    fl_clear_choice(sim_selection);
    if(remoteList->num() > 0) {
      for(int i=0; i < remoteList->num(); i++) {
        fl_addto_choice(sim_selection, (remoteList->remote(i))->name);
	if(remoteList->is_top(i))
          fl_set_choice(sim_selection, i+1);
      }
    }
  unfreeze();
}


// reset the parameter browser based on the top simulation
void SimFormsObj::reset_parameters(void) {
  MoleculeRemote *m = remoteList->top();
  char parambuf[64], pvalbuf[32];

  freeze();
    if(m == NULL) {
      fl_hide_object(sim_parameters);
      fl_hide_object(sim_disconnected_msg);
    } else {
      if((m->rem)->running_simulation()) {
        fl_show_object(sim_parameters);
        fl_hide_object(sim_disconnected_msg);
        fl_clear_browser(sim_parameters);
        for(int i=0; i < (m->rem)->avail_settings(); i++) {
	  (m->rem)->get_setting(i, pvalbuf);
	  sprintf(parambuf,"%13s",remoteSettingName[i]);
	  strcat(parambuf, pvalbuf);
	  fl_add_browser_line(sim_parameters, parambuf);
	}
      } else {
        fl_hide_object(sim_parameters);
        fl_show_object(sim_disconnected_msg);
      }
    }
    
    // regardless, no longer editing a parameter
    set_edit_parameter(-1);
  unfreeze();
}


// change between editing the Nth parameter, or not
void SimFormsObj::set_edit_parameter(int n) {
  MoleculeRemote *m = remoteList->top();
  char pvalbuf[32];

  freeze();
    if(m == NULL || n < 0 || n >= (m->rem)->avail_settings()) {
      fl_hide_object(sim_change_input);
      fl_deselect_browser(sim_parameters);
      editParam = (-1);
    } else {
      editParam = n;
      fl_select_browser_line(sim_parameters, editParam + 1);
      fl_show_object(sim_change_input);
      (m->rem)->get_setting(remoteSettingKeyword[editParam], pvalbuf);
      fl_set_input(sim_change_input, pvalbuf);
    }
  unfreeze();
}


// update patch display method selector, if applicable
// Also hides items which are useful only when a top simulation is selected
void SimFormsObj::reset_patch_display(void) {
  MoleculeRemote *m = remoteList->top();

  freeze();
    if(!m) {
      fl_set_choice(sim_patch_method, DrawPatch::BYNONE + 1);
      fl_hide_object(sim_disconnect);
      fl_hide_object(sim_kill);
    } else {
      fl_set_choice(sim_patch_method, m->patch_display_method() + 1);
      fl_show_object(sim_disconnect);
      fl_show_object(sim_kill);
    }
  unfreeze();
}


// update sim status display
void SimFormsObj::reset_sim_status(void) {
  MoleculeRemote *m = remoteList->top();
  char txtbuf[128];

  freeze();
    if(m == NULL) {
      fl_clear_browser(sim_status);
    } else {
      fl_clear_browser(sim_status);
      Timestep *ts = m->current();
      sprintf(txtbuf,   "  Status: %s", (m->rem)->status());
      fl_add_browser_line(sim_status, txtbuf);
      sprintf(txtbuf,   "    Host: %s", (m->rem)->host());
      fl_add_browser_line(sim_status, txtbuf);
      sprintf(txtbuf,   " # steps: %d", m->step());
      fl_add_browser_line(sim_status, txtbuf);
      fl_add_browser_line(sim_status, "---------------------");
      if(ts) {
        sprintf(txtbuf, "Timestep: %f", ts->dt);
        fl_add_browser_line(sim_status, txtbuf);
        sprintf(txtbuf, "    Temp: %f", ts->energy[TSE_TEMP]);
        fl_add_browser_line(sim_status, txtbuf);
        sprintf(txtbuf, " Total E: %f", ts->energy[TSE_TOTAL]);
        fl_add_browser_line(sim_status, txtbuf);
        sprintf(txtbuf, "      KE: %f", ts->energy[TSE_KE]);
        fl_add_browser_line(sim_status, txtbuf);
        sprintf(txtbuf, "      PE: %f", ts->energy[TSE_PE]);
        fl_add_browser_line(sim_status, txtbuf);
	sprintf(txtbuf, "  Bond E: %f", ts->energy[TSE_BOND]);
        fl_add_browser_line(sim_status, txtbuf);
	sprintf(txtbuf, "   vdW E: %f", ts->energy[TSE_VDW]);
        fl_add_browser_line(sim_status, txtbuf);
	sprintf(txtbuf, "  Coul E: %f", ts->energy[TSE_COUL]);
        fl_add_browser_line(sim_status, txtbuf);
	if(ts->numPatches > 0) {
	  sprintf(txtbuf, " Patches: %d", ts->numPatches);
          fl_add_browser_line(sim_status, txtbuf);
	}
      }
    }
  unfreeze();
}


//////////////////////  protected virtual routines  

// routine to check the main form for use
int SimFormsObj::check(FL_OBJECT *obj) {

  if(obj == sim_selection) {
    addcommand(new CmdRemoteTop(
    	(remoteList->remote(fl_get_choice(obj) - 1)) -> id(), id()));

  } else if(obj == sim_parameters) {
    set_edit_parameter(fl_get_browser(obj) - 1);
    
  } else if(obj == sim_change_input) {
    addcommand(new CmdRemoteChangeParam(remoteSettingKeyword[editParam],
    	fl_get_input(obj), id()));

  } else if(obj == sim_patch_method) {
    addcommand(new CmdRemotePatchDisplay(fl_get_choice(obj) - 1, id()));
    
  } else if(obj == sim_disconnect) {
    if(remoteList->top())
      addcommand(new CmdRemoteDetach((remoteList->top())->id(), id()));
    
  } else if(obj == sim_kill) {
    if(remoteList->top())
      addcommand(new CmdRemoteKill((remoteList->top())->id(), id()));
    
  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
int SimFormsObj::forms_act_on_command(int type, Command *, int) {

  MSGDEBUG(3,"SimFormsObj: acting on command " << type << sendmsg);

  if(type == Command::SIM_TOP || type == Command::SIM_DETACH ||
	type == Command::SIM_KILL) {
    reset();

  } else if(type == Command::SIM_SETPARAM) {
    reset_parameters();
    
  } else if(type == Command::SIM_PATCHDISP) {
    reset_patch_display();

  } else
    // unknown command type
    return FALSE;
    
  return TRUE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void SimFormsObj::init(void) {
  freeze();
    // set all the basic values for controllers, etc
    fl_set_browser_fontstyle(sim_parameters,FL_FIXED_STYLE);
    fl_set_browser_fontstyle(sim_status,FL_FIXED_STYLE);
   
    // add initial values to sim_patch_method selector
    fl_clear_choice(sim_patch_method);
    for(int i=0; i < DrawPatch::TOTAL_PATCH_DISPLAY; i++)
      fl_addto_choice(sim_patch_method, patchDisplayMethodName[i]);
    fl_set_choice(sim_patch_method, DrawPatch::BYNONE + 1);

    // do a reset to set initial values
    reset();

  unfreeze();
}


// reset the user interface
void SimFormsObj::reset(void) {
  freeze();
    reset_sim_selection();
    reset_parameters();
    reset_patch_display();
    reset_sim_status();
  unfreeze();
}


// update the user interface
void SimFormsObj::update(void) {
  if(displayed()) {
    reset_sim_status();
  }
}

#endif
