/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Stack.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/01/29 19:57:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Stack template
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Stack.h,v $
 * Revision 1.2  1995/01/29  19:57:16  billh
 * Moved almost all in-lined functions to .c file
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/

#ifndef STACK_TEMPLATE_H
#define STACK_TEMPLATE_H


template<class T>
class Stack {

private:
  // list of items, and pointer to current item
  T *data, *curr;

  // number of items, and items currently on stack
  int sz, items;
  
public:
  // constructor/destructor
  Stack(int s);
  ~Stack(void);

  //
  // query status of this class
  //
  
  // return maximum, and current, size of stack
  int max_stack_size(void) { return sz; }
  int stack_size(void) { return items; }
  int num(void) { return items; }

  //
  // routine to manipulate the stack
  //

  // push a new item onto the stack.
  Stack<T>& push(const T&);
  
  // push the stack, making a copy of the top element
  Stack<T>& push(void);
  
  // pop the stack
  T& pop(void);
  
  // return reference to top item, but do not pop the stack
  T& top(void);

};

#endif
