/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIExternal.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/22 08:55:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This provides a very simple interface by which external commands
 * may be entered into vmd as if they were text commands.  This
 * interface uses PVM for the communications, because that's what
 * I know how to use.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UIExternal.C,v $
 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/UIExternal.C,v 1.1 1995/02/22 08:55:55 dalke Exp $";
#endif




#include "UIExternal.h"
#include "CommandQueue.h"
#include "UIText.h"
#include "utilities.h"
#ifdef VMDEXTERNAL
#include "pvm3.h"
#endif

const int numCmds = 0; // someday maybe I'll listen??
int UIExternal::pvmcount = 0;
int UIExternal::uniqid = 0;

static int cmdList[] = {Command::EXTERNAL_START,
		         Command::EXTERNAL_END};

// constructor
UIExternal::UIExternal(UIList *uil, CommandQueue *cq)
: UIObject("External Interface", uil, cq) {
   myid = ++uniqid;
   MSGDEBUG(1, "Started External interface " << myid << " ..." << sendmsg);
   for (int i=0; i<numCmds; i++) {
      command_wanted(cmdList[i]);
   }
   ison = FALSE;
}

UIExternal::~UIExternal(void)
{
   MSGDEBUG(1, "Stopped External interface " << myid << " ..." << sendmsg);
   if (ison) {
      leave_pvm();
   }
}


// if I'm listening for external PVM commands,
// see if I got one, and put it on the queue
int UIExternal::check_event(void)
{
#ifdef VMDEXTERNAL
   int bufid;
   if (ison) {
      if ((bufid = pvm_nrecv(-1, EXTERNAL_TEXTEVENT)) > 0) { // probe for msg
	 char newstr[EXTERNALD_MAXSTRLEN+1];
	 int info = pvm_upkstr( newstr);                     // get the string
	 if (info == 0) {
	    addcommand(new TextEvent(stringdup(newstr), id())); // and enque it
	    return TRUE;
	 } else {
	    msgErr << "Problem with unpacking an external message" << sendmsg;
	 }
      }
   }
#endif
   return FALSE;
}


// either start or end checking for external functions
int UIExternal::start_listening(void)
{
#ifndef VMDEXTERNAL
   return FALSE;
#else
   if (ison) {
      msgWarn << "External PVM interface already turned on" << sendmsg;
      return TRUE;
   }
   int temptid = pvm_mytid(); // starts up pvm
   if (temptid < 0) {
      msgErr<<"PVM had not been started, or could not be found." << sendmsg;
      msgErr << "I will not try to start it up myself." << sendmsg;
      return FALSE;
   } else {
      pvmcount++;
      if ( pvm_joingroup("vmd") < 0) {
 msgErr << "Try starting the group server, $HOME/pvm3/lib/$ARCH/pvmgs.";
 msgErr << sendmsg;
 msgErr << "You may want to: ln -s $HOME/pvm3/lib/$ARCH/pvmgs ";
 msgErr << "$HOME/pvm3/bin/$ARCH/" << sendmsg;
         leave_pvm();
	 return FALSE;
      }
      msgInfo << "External PVM interface " << myid << " on" << sendmsg;
      ison = TRUE;
      return TRUE;
   }
#endif
}

// detach from the pvm 
int UIExternal::stop_listening(void)
{
   if (!ison) {  // doesn't try to force a withdraw from PVM
      msgErr << "External PVM interface " << myid << " not on" << sendmsg;
      return FALSE;
   }
   leave_pvm();
   return TRUE;
}


// stop listening to pvm
// if there are no other UIExternals running, remove myself from
// the PVM
void UIExternal::leave_pvm(void)
{
#ifdef VMDEXTERNAL
   if (pvmcount <=0 ) {
      msgErr << "Too many attempts to leave PVM" << sendmsg;
      pvmcount=1;
   }
   pvmcount--;
   ison = FALSE;
   msgErr << "External interface " << myid << " leaving PVM" << sendmsg;
   if (pvmcount ==0 ) {
      if (pvm_exit() < 0 ) {
	 msgErr << "Could not contact PVM to disconnect???" << sendmsg;
      } else {
	 msgInfo << "All External interfaces removed from PVM" << sendmsg;
      }
   } else {
      msgInfo << pvmcount << " External interfaces remain" << sendmsg;
   }
#endif
}
