/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1994/10/05 07:05:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 *  This is the object that maintains the list of all User Interfaces.
 *  The idea is that we create all the UIs (forms, 3D, text, ...) at the
 *  beginning of the program and "register_UI".  Then, during the main
 *  event loop, these UIs are told, first, to check for any events that
 *  occured and put commands on the command queue.  After that step, the
 *  commands are executed and the UIs told about the results of each.
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UIList.h,v $
 * Revision 1.4  1994/10/05  07:05:23  billh
 * moved some routines to .C file.
 *
 * Revision 1.3  1994/10/05  06:58:16  billh
 * Converted to use a ResizeArray instead of a DLinkList in the command queue
 * and ui list.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef UILIST_H
#define UILIST_H

#include "ResizeArray.h"
#include "Command.h"
#include "UIObject.h"
#include "utilities.h"
#include "Inform.h"
#include "Global.h"


/* NOTES:
 *	1) When a UIObject is created, it should be registered with a UIList.
 *	2) There is currently no way to 'unregister' a UI.
 */

class UIList {

private:
  // list of ui objects
  ResizeArray<UIObject *> uilist;

public:
  // constructor ... nothing to do, done by DLinkList derivation  ;-)
  UIList( void) : uilist(16)
    { MSGDEBUG(1,"Creating UI List ..." << sendmsg); }
  virtual ~UIList( void) { MSGDEBUG(1,"Deleting UI List ..." << sendmsg); }

  // return number of ui's
  int num(void) { return uilist.num(); }

  // return the first UI with given name; NULL if no match found
  UIObject *item(char *);
  
  // return the Nth item
  UIObject *item(int n) {
    UIObject *retval = NULL;
    if(n >= 0 && n < num())
      retval = uilist[n];
    return retval;
  }

  // Stick a new UI in the list and return index (unique, since we do not
  // ever unregister UIObjects)
  int register_UI(UIObject *);

  // make all registered UI's reset     
  void reset_UI(void);
  
  // make all registered UI's init     
  void init_UI(void);

  // make all registered UI's update     
  void update_UI(void);

  // make all registered UI's check for an event     
  void check_event_UI(void);

  // send a Command to the UIs after it has been executed
  void act_on_command_UI(Command::Cmdtype, Command *, int);
  
  // the simpler (and slower) interface
  void act_on_command(Command *cmd) { 
    act_on_command_UI(cmd -> gettype(), cmd, TRUE);
  }

};  // end class description for UIList

#endif
