/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UNCTracker.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/09/03 11:18:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A UNCTracker is a device for measuring the 3D spacial position of an input
 * device; it is a subclass of the Tracker class.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UNCTracker.h,v $
 * Revision 1.1  1994/09/03  11:18:18  dalke
 * Initial revision
 *
 * Revision 1.4  1994/04/20  23:08:33  billh
 * Fixed RCS header in files to include description; set most files to
 * include Global.h, and not ever main.h.  Global.h includes config.h and
 * utilities.h automatically, as well as Message.h for the output message
 * objects.
 *
 * Revision 1.3  1994/04/16  00:36:33  billh
 * Changed program name to vmd, added RCS header section.
 *
 ***************************************************************************/

#ifndef POLHEMUS_H
#define POLHEMUS_H

// project include files
#include "Tracker.h"
// UNC include files
extern "C" {
#include "tracker.h"
}

#define POL_MAXSENSORS	4


class UNCTracker : public Tracker {

private:
  
  // name of tracker
  t_name_type polName;

  // index for use with the UNC library
  t_index polIndex;

  // data structure for holding the data returned from the UNC library 
  t_report_type uncReport[POL_MAXSENSORS];

  // last return value from t_read
  int readRetval;

protected:
  // virtual routine which reads data from sensors, if available
  // returns TRUE if data read and variables changed, FALSE otherwise;
  virtual int my_get_data(int, float *, float *, float *, float *, int);

public:
  // constructors and destructors
  UNCTracker(char *name, int num_sensors = POL_MAXSENSORS);
  virtual ~UNCTracker(void);

};

#endif
