/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: startup.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/01/09 08:54:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Startup code for VMD ... used only by Global files, contains variables
 * and routines to read initial data files and scripts, and parse
 * command-line options.
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: startup.h,v $
 * Revision 1.1  1995/01/09  08:54:17  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef STARTUP_VMD_H
#define STARTUP_VMD_H

/***************************************************************************
 enumerates for different initial status variables, such as the type of
 display to use at startup
 ***************************************************************************/

// display types at startup
enum DisplayTypes { DISPLAY_WIN, DISPLAY_CAVE, DISPLAY_TEXT, NUM_DISPLAY_TYPES};

// how to show the title
enum TitleTypes { TITLE_OFF, TITLE_ON, NUM_TITLE_TYPES };

/***************************************************************************
 string names for these enumerates
 ***************************************************************************/
extern char *displayTypeNames[];
extern char *titleTypeNames[];

/***************************************************************************
 initial status variables, used to control how VMD starts up
 ***************************************************************************/

extern int which_display;		  // type of display to use
extern float displayHeight, displayDist;  // height and distance of display
extern int displaySize[2], displayLoc[2]; // X,Y size and position of display
extern int showTitle;			  // how to show the title at start

/***************************************************************************
 function prototypes for startup routines
 ***************************************************************************/
extern void VMDparseCommandLine(int, char **);
extern void VMDreadInit(void);
extern void VMDreadStartup(void);

#endif
