/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: AtomRep.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.6 $      $Date: 95/03/24 18:47:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Parse and maintain the data for how a molecule should be represented.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	AtomRep.h,v $
 * Revision 1.6  95/03/24  18:47:04  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.5  1994/12/11  01:14:47  dalke
 * Added ribbons - warning - it workds, bu the ribbon interface
 *  WILL change
 *
 * Revision 1.4  1994/11/03  01:03:05  billh
 * Changed text and enum name for 'off' option in atom representation.
 *
 * Revision 1.3  1994/11/02  23:32:44  billh
 * Added 'none' option to AtomRep to quickly turn off graphics reps
 *
 * Revision 1.2  1994/10/26  23:19:44  billh
 * Removed 'ok' member; removed initial string in constructor; added 'cmd_parse'
 * and operator= routines, as well as 'change' routine.
 *
 * Revision 1.1  94/09/23  06:01:39  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef ATOMREP_H
#define ATOMREP_H

#include "utilities.h"

// default atom representation, and max cmd string size
#define DEFAULT_ATOMREP		AtomRep::LINES
#define MAX_ATOMREP_CMD		255


class AtomRep {

public:
  // different methods for representing atoms
  enum RepMethod { LINES, CPK, VDW, DOTTED, LICORICE, RIBBONS, REPOFF, TOTAL };

  // initial string with representation command
  char cmdStr[MAX_ATOMREP_CMD + 1];
  
private:
  // results of command ... how to represent atoms, and some parameters
  RepMethod repMethod;
  float sphereRad, bondRad;
  int sphereRes, bondRes, lineThickness;

  // parse the given command, and store results.  Return success.
  int parse_cmd(char *);

public:
  AtomRep(void);
  AtomRep(AtomRep&);
  ~AtomRep(void) { }
  
  // equal operator, to change the current settings.
  AtomRep& operator=(const AtomRep &);

  // provide new settings
  int change(char *newcmd) { return parse_cmd(newcmd); }

  //
  // info about current settings
  //

  // return representation method
  int method(void) { return repMethod; }
  
  // return sphere radius (may not be applicable)
  float sphere_rad(void) { return sphereRad; }
  
  // return bond radius (may not be applicable)
  float bond_rad(void) { return bondRad; }

  // return sphere res (may not be applicable)
  int sphere_res(void) { return sphereRes; }
  
  // return bond res (may not be applicable)
  int bond_res(void) { return bondRes; }
  
  // return line thickness (may not be applicable)
  int line_thickness(void) { return lineThickness; }
};

// a string array with text descriptions of representation methods
extern char *AtomRepName[AtomRep::TOTAL];

#endif
