/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Buttons.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 95/03/24 18:47:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Base class for button type inputs which are associated with a tracker/
 * sensor pair.  Also includes two derived classes, KbdButtons (for keyboard
 * entry with the F keys) and CaveButtons (for input from the Cave).
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Buttons.h,v $
 * Revision 1.4  95/03/24  18:47:18  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/11/08  09:12:15  dalke
 * set up CaveButtons correctly
 *
 * Revision 1.2  1994/09/17  10:53:18  dalke
 * added RCS header
 *
 ***************************************************************************/
#ifndef BUTTONS_H
#define BUTTONS_H
#include "utilities.h"


// base class for the different types of button inputs
class Buttons {

protected:
  int *state;      // place to store the button info so I don't
                   //   constantly repoll the same data
  int *changes;    // not FALSE indicated that that button changed since
                   //   the last polling
  int has_changed; // has anything changed since the last time?  Here for
                   // speed
  int numButtons;  // how many buttons this object contains

public:
  // constructor: number of buttons this object contains
  Buttons(int);
  virtual ~Buttons(void);

  // number of buttons
  int num(void) { return numButtons; }
  
  // return state of a button -- TRUE is on, FALSE is off
  int button(int buttonnum) { 
    return 0<= buttonnum && buttonnum < num() ?
             state[buttonnum] : FALSE;
  }
  
  // return the value by which a button has changed
  int change(int buttonnum) {
     return 0<= buttonnum && buttonnum < num() ?
              changes[buttonnum] : 0;
  }

  // for speed, I want to know if anything has changed since the last
  // polling w/o actually checking all the state variables
  int changed(void) { 
    return has_changed; 
  }
  
  // get the current button state.  If it changed, generate a Command
  virtual void check_event(void) = 0;
};


/////////////////////////  KbdButtons derived class  ////////////////////////

// Takes input from the keyboard
class KbdButtons : public Buttons {

private:
  int my_bank;  // which bank of F keys to use, (F1, F2, F3) , (F5, ...)
  int *tmp_state;  // temp, but I don't want to new mem every time

public:
  // constructor: which bank to use
  KbdButtons(int);
  
  // destructor
  virtual ~KbdButtons(void);
  
  // get the current button state.  If it changed, generate a Command
  virtual void check_event(void);
};


/////////////////////////  CaveButtons derived class  ////////////////////////

#ifdef VMDCAVE
// Takes input from the CAVE buttons
class CaveButtons : public Buttons {

private:
  int *tmp_state;  // temp, but I don't want to new mem every time

public:
  // constructor
  CaveButtons( void );
  
  // destructor
  virtual ~CaveButtons( void );
  
  // get the current button state.  If it changed, generate a Command
  virtual void check_event(void);
};

#endif // VMDCAVE

#endif // BUTTONS_H
