/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdAnimate.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 95/03/24 18:47:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for doing animation.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdAnimate.C,v $
 * Revision 1.3  95/03/24  18:47:37  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/22  02:30:51  billh
 * Added commands to read/write/delete frames from a molecule.
 *
 * Revision 1.1  94/10/20  01:30:58  billh
 * Initial revision
 *  
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdAnimate.C,v 1.3 95/03/24 18:47:37 billh Exp $";
#endif

#include "CmdAnimate.h"
#include "MolAction.h"
#include "Global.h"

// The following uses  the Cmdtypes:
//	ANIM_DIRECTION, ANIM_JUMP, ANIM_SKIP, ANIM_STYLE, ANIM_SPEED,
//	ANIM_READ, ANIM_WRITE, ANIM_DELETE

//////////////////// set direction of animation
int CmdAnimDir::do_execute(void) {
  int retval;
  if(retval = (moleculeList != NULL)) {
    if(newDir == Animation::REVERSE) {
      MolReverse action;
      moleculeList->act(action, whichMol);
    } else if(newDir == Animation::REVERSE1) {
      MolReverse1 action;
      moleculeList->act(action, whichMol);
    } else if(newDir == Animation::FORWARD) {
      MolForward action;
      moleculeList->act(action, whichMol);
    } else if(newDir == Animation::FORWARD1) {
      MolForward1 action;
      moleculeList->act(action, whichMol);
    } else if(newDir == Animation::PAUSE) {
      MolPause action;
      moleculeList->act(action, whichMol);
    }
  }
  return retval;
}

CmdAnimDir::CmdAnimDir(Animation::AnimDir ad, int newUIid)
  : Command(Command::ANIM_DIRECTION, newUIid) {
  newDir = ad;
  whichMol = MoleculeList::ACTIVE;
  
  *cmdText << "anim ";
  if(newDir == Animation::REVERSE)
    *cmdText << "reverse";
  else if(newDir == Animation::REVERSE1)
    *cmdText << "prev";
  else if(newDir == Animation::FORWARD)
    *cmdText << "forward";
  else if(newDir == Animation::FORWARD1)
    *cmdText << "next";
  else if(newDir == Animation::PAUSE)
    *cmdText << "pause";
  *cmdText << ends;
}


//////////////////// set style of animation
int CmdAnimStyle::do_execute(void) {
  int retval;
  if(retval = (moleculeList != NULL)) {
    MolAnimStyle action(newStyle);
    moleculeList->act(action, whichMol);
  }
  return retval;
}

CmdAnimStyle::CmdAnimStyle(Animation::AnimStyle as, int newUIid)
  : Command(Command::ANIM_STYLE, newUIid) {
  newStyle = as;
  whichMol = MoleculeList::ACTIVE;
  
  *cmdText << "anim style " << animationStyleName[newStyle];
  *cmdText << ends;
}


//////////////////// jump to a new frame
int CmdAnimJump::do_execute(void) {
  int retval;
  if(retval = (moleculeList != NULL)) {
    MolSetFrame action(newFrame);
    moleculeList->act(action, whichMol);
  }
  return retval;
}

CmdAnimJump::CmdAnimJump(int newval, int newUIid)
  : Command(Command::ANIM_JUMP, newUIid) {
  newFrame = newval;
  whichMol = MoleculeList::ACTIVE;
  
  *cmdText << "anim goto " << newFrame;
  *cmdText << ends;
}


//////////////////// set frame skip value
int CmdAnimSkip::do_execute(void) {
  int retval;
  if(retval = (moleculeList != NULL)) {
    MolSetSkip action(newSkip);
    moleculeList->act(action, whichMol);
  }
  return retval;
}

CmdAnimSkip::CmdAnimSkip(int newval, int newUIid)
  : Command(Command::ANIM_SKIP, newUIid) {
  newSkip = newval;
  whichMol = MoleculeList::ACTIVE;
  
  *cmdText << "anim skip " << newSkip;
  *cmdText << ends;
}


//////////////////// set animation speed
int CmdAnimSpeed::do_execute(void) {
  int retval;
  if(retval = (moleculeList != NULL)) {
    MolSetSpeed action(newSpeed);
    moleculeList->act(action, whichMol);
  }
  return retval;
}

CmdAnimSpeed::CmdAnimSpeed(float newval, int newUIid)
  : Command(Command::ANIM_SPEED, newUIid) {
  newSpeed = newval;
  whichMol = MoleculeList::ACTIVE;
  
  *cmdText << "anim speed " << newSpeed;
  *cmdText << ends;
}


//////////////////// append new frames from a file
int CmdAnimReadFile::do_execute(void) {
  int retval;
  Molecule *m;
  if(retval = (moleculeList != NULL)) {
    if(whichMol >= 0)
      m = moleculeList->molecule(moleculeList->mol_index_from_id(whichMol));
    else
      m = moleculeList->top();
    if(!m) {
      msgErr << "Illegal molecule ID " << whichMol << " specified." << sendmsg;
      retval = FALSE;
    } else {
      retval=m->read_coor_file(fileName,fileType,begFrame,endFrame,frameSkip);
      if(!retval) {
        msgErr << "Unable to open coordinate file " << fileName;
        msgErr << " for reading." << sendmsg;
      } else {
        msgInfo << "Opened coordinate file " << fileName << " for reading.";
        msgInfo << sendmsg;
      }
    }
  }
  return retval;
}

CmdAnimReadFile::CmdAnimReadFile(int m, char *n, int t, int bf, int ef, int fs,
  			int newUIid) : Command(Command::ANIM_READ, newUIid) {
  whichMol = m;
  fileType = t;
  begFrame = bf;
  endFrame = ef;
  frameSkip = fs;
  fileName = stringdup(n);
  
  *cmdText << "anim read " << CoorFileSuffix[fileType] << " " << fileName;
  *cmdText << " beg " << begFrame;
  *cmdText << " end " << endFrame;
  *cmdText << " skip " << frameSkip;
  if(whichMol >= 0)
    *cmdText << " " << whichMol;
  *cmdText << ends;
}

CmdAnimReadFile::~CmdAnimReadFile(void) {
  delete [] fileName;
}



//////////////////// write frames to a file
int CmdAnimWriteFile::do_execute(void) {
  int retval;
  Molecule *m;
  if(retval = (moleculeList != NULL)) {
    if(whichMol >= 0)
      m = moleculeList->molecule(moleculeList->mol_index_from_id(whichMol));
    else
      m = moleculeList->top();
    if(!m) {
      msgErr << "Illegal molecule ID " << whichMol << " specified." << sendmsg;
      retval = FALSE;
    } else {
      retval=m->write_coor_file(fileName,fileType,begFrame,endFrame,frameSkip);
      if(!retval) {
        msgErr << "Unable to open coordinate file " << fileName;
        msgErr << " for writing." << sendmsg;
      } else {
        msgInfo << "Opened coordinate file " << fileName << " for writing.";
        msgInfo << sendmsg;
      }
    }
  }
  return retval;
}

CmdAnimWriteFile::CmdAnimWriteFile(int m, char *n, int t, int bf,int ef,int fs,
  			int newUIid) : Command(Command::ANIM_WRITE, newUIid) {
  whichMol = m;
  fileType = t;
  begFrame = bf;
  endFrame = ef;
  frameSkip = fs;
  fileName = stringdup(n);
  
  *cmdText << "anim write " << CoorFileSuffix[fileType] << " " << fileName;
  *cmdText << " beg " << begFrame;
  *cmdText << " end " << endFrame;
  *cmdText << " skip " << frameSkip;
  if(whichMol >= 0)
    *cmdText << " " << whichMol;
  *cmdText << ends;
}

CmdAnimWriteFile::~CmdAnimWriteFile(void) {
  delete [] fileName;
}


//////////////////// delete frames
int CmdAnimDelete::do_execute(void) {
  int retval;
  Molecule *m;
  if(retval = (moleculeList != NULL)) {
    if(whichMol >= 0)
      m = moleculeList->molecule(moleculeList->mol_index_from_id(whichMol));
    else
      m = moleculeList->top();
    if(!m) {
      msgErr << "Illegal molecule ID " << whichMol << " specified." << sendmsg;
      retval = FALSE;
    } else {
      // delete specified frames from this molecule
      int eframe = (endFrame >= 0 ? endFrame : m->num() - 1);
      int bframe = (begFrame >= 0 ? begFrame : 0);
      int fskip = (frameSkip >= 1 ? frameSkip : 1);
      int deleted = 0;
      while(bframe <= eframe) {
        m->delete_frame(bframe);
	eframe--;
	bframe += (fskip - 1);
	deleted++;
      }
      msgInfo << "Finished deleting " << deleted << " frames from molecule ";
      msgInfo << m->name << sendmsg;
    }
  }
  return retval;
}

CmdAnimDelete::CmdAnimDelete(int m, int bf, int ef, int fs, int newUIid)
	: Command(Command::ANIM_DELETE, newUIid) {
  whichMol = m;
  begFrame = bf;
  endFrame = ef;
  frameSkip = fs;
  
  *cmdText << "anim delete ";
  if(begFrame < 0 && endFrame < 0 && frameSkip < 0) {
    *cmdText << "all";
  } else {
    *cmdText << " beg " << begFrame;
    *cmdText << " end " << endFrame;
    *cmdText << " skip " << frameSkip;
  }
  if(whichMol >= 0)
    *cmdText << " " << whichMol;
  *cmdText << ends;
}
