/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdExternal.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/03/24 18:47:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Turn the UIExternal either on or off
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdExternal.C,v $
Revision 1.1  95/03/24  18:47:46  billh
Initial revision

 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdExternal.C,v 1.1 95/03/24 18:47:46 billh Exp $";
#endif

#include "CmdExternal.h"
#include "UIExternal.h"
#include "Inform.h"
#include "Global.h"


////////////////////// start a new external interface
CmdExternalStart::CmdExternalStart(int fromUIid)
	: Command(Command::EXTERNAL_START, fromUIid) {

  *cmdText << "external start" << ends;
}


int CmdExternalStart::do_execute(void) { 
   return uiExternal -> start_listening();
}


////////////////////// turn off an external interface
CmdExternalEnd::CmdExternalEnd(int fromUIid)
	: Command(Command::EXTERNAL_END, fromUIid) {

  *cmdText << "external end" << ends;
}


int CmdExternalEnd::do_execute(void) { 
   return uiExternal -> stop_listening();
}
