/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdPick.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.2 $      $Date: 95/03/24 18:47:59 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 	The picking commands are defined here.  A picking command must
 * know which button was used, what the x,y position was, and what was
 * the picking mode.
 *
 *	The x,y position (for 2D picking) is relative to the windows lower-
 * left corner, and scaled to be in the range 0 ... 1.  A general utility
 * routine "rel_screen_pos" in the DisplayDevice class converts absolute
 * screen coordinates for the given display into these relative coords.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdPick.C,v $
 * Revision 1.2  95/03/24  18:47:59  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/22  03:56:04  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdPick.C,v 1.2 95/03/24 18:47:59 billh Exp $";
#endif

#include "CmdPick.h"
#include "Scene.h"
#include "Global.h"


//////////// general base class for picking commands
CmdPickBase::CmdPickBase(Cmdtype c, char *cmdname,
  	int b, int m, int d, float x, float y, float z, int uiid)
	: Command(c, uiid) {
  pickMode = (m >= 0 ? m : 0);
  button = (b >= 0 && b < 2 ? b : 0);
  dim = (d > 1 && d < 4 ? d : 2);
  p[0] = x;
  p[1] = y;
  p[2] = z;
  *cmdText << "# pick " << cmdname << " " << button << " " << x << " " << y;
  if(dim > 2)
    *cmdText << " " << z;
  *cmdText << ends;
}


//////////// start picking an object
int CmdPickStart::do_execute(void) {

  if(scene && display) {
    return (scene->pick_start(display, button, pickMode, dim, p) >= 0);
  }
  
  // if here, command failed
  return FALSE;
}


//////////// end picking an object
int CmdPickEnd::do_execute(void) {

  if(scene && display) {
    return scene->pick_end(display, button, pickMode, dim, p);
  }
  
  // if here, command failed
  return FALSE;
}


//////////// move during a picking operation
int CmdPickMove::do_execute(void) {

  if(scene && display) {
    return scene->pick_move(display, button, pickMode, dim, p);
  }
  
  // if here, command failed
  return FALSE;
}
