/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdRemote.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 95/03/24 18:48:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for affecting remote connections.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdRemote.h,v $
 * Revision 1.3  95/03/24  18:48:04  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/10/21  03:50:45  billh
 * Updated for new simulation control commands, and remoteList object.
 *
 * Revision 1.1  1994/10/01  11:04:31  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDREMOTE_H
#define CMDREMOTE_H

#include "Command.h"


// the following uses the Cmdtypes REMOTE_INIT, REMOTE_CANCEL, REMOTE_LIST,
//	REMOTE_NEW, REMOTE_ATTACH, REMOTE_RUN, REMOTE_SETOPT, REMOTE_READOPT,
//	REMOTE_WRITEOPT,
//	SIM_SETPARAM, SIM_PATCHDISP, SIM_TOP, SIM_DETACH, SIM_KILL, SIM_LIST

///////////// initialize remote with a new connection
class CmdRemoteInit : public Command {
protected:
  char *username, *computer;	// username and computer to use
  virtual int do_execute(void);
  
public:
  CmdRemoteInit(char *, char *, int=(-1));
  virtual ~CmdRemoteInit(void);
};


//////////// cancel the current connection
class CmdRemoteCancel : public Command {
protected:
  virtual int do_execute(void);
  
public:
  CmdRemoteCancel(int=(-1));
};


/////////////// list the current remote objects settings
class CmdRemoteList : public Command {
public:
  // what to list (default is ALL)
  enum RemoteList { ALL, JOBS, APPS, PARAMS };

protected:
  RemoteList whatToList;		// what should be displayed?
  virtual int do_execute(void);

public:
  CmdRemoteList(RemoteList, int=(-1));
};


/////////////// set the remote connection setup to get the parameters
/////////////// to start a new job on the remote computer, using the selected
/////////////// app.  App is an index into the list of possible applications
/////////////// that can be started.
class CmdRemoteNew : public Command {
protected:
  int whichApp;			// index of application to select
  virtual int do_execute(void);

public:
  CmdRemoteNew(int, int=(-1));
};


/////////////// have the remote simulation attach to the specified currently-
/////////////// running job ... a new molecule will be created if this is
/////////////// successful
class CmdRemoteAttach : public Command {
protected:
  int whichJob;			// index of job to attach to
  virtual int do_execute(void);

public:
  CmdRemoteAttach(int, int=(-1));
};


/////////////// creates a new simulation using previously established
/////////////// parameters.  Only works if a CmdRemoteNew command has been
/////////////// executed previously
class CmdRemoteRun : public Command {
protected:
  virtual int do_execute(void);

public:
  CmdRemoteRun(int=(-1));
};


/////////////// sets the value for the Nth parameter in the current
/////////////// remote simulation being set up.  Only works if parameters
/////////////// are being edited.
class CmdRemoteSetopt : public Command {
protected:
  char *keyword;			// or, can use a keyword to specify
  char *paramVal;			// new value for parameter
  virtual int do_execute(void);

public:
  CmdRemoteSetopt(char *, char *, int=(-1));
  virtual ~CmdRemoteSetopt(void);
};


/////////////// read in parameter values from the given file.
/////////////// Only works if a CmdRemoteNew command has been
/////////////// executed previously
class CmdRemoteReadopt : public Command {
protected:
  char *fname;				// name of file
  virtual int do_execute(void);

public:
  CmdRemoteReadopt(char *, int=(-1));
  virtual ~CmdRemoteReadopt(void);
};


/////////////// write current parameter values to the given file.
/////////////// This will work as long as the current remote object has
/////////////// any parameters to write.
class CmdRemoteWriteopt : public Command {
protected:
  char *fname;				// name of file
  virtual int do_execute(void);

public:
  CmdRemoteWriteopt(char *, int=(-1));
  virtual ~CmdRemoteWriteopt(void);
};


/////////////// issue command to change parameter for top remote connection.
class CmdRemoteChangeParam : public Command {
protected:
  char *param;				// which parameter
  char *newval;				// new value
  virtual int do_execute(void);
public:
  CmdRemoteChangeParam(char *, char *, int=(-1));
  virtual ~CmdRemoteChangeParam(void);
};


/////////////// change how patches are displayed (if they are even available)
class CmdRemotePatchDisplay : public Command {
protected:
  int newval;			// new display setting
  virtual int do_execute(void);
public:
  CmdRemotePatchDisplay(char *, int=(-1));
  CmdRemotePatchDisplay(int, int=(-1));
};


/////////////// set the specified molecule as the top remote connection
class CmdRemoteTop : public Command {
protected:
  int id;			// which molecule to make top (ID of molecule)
  virtual int do_execute(void);
public:
  CmdRemoteTop(int, int=(-1));
};


/////////////// detach from a running simulation, but don't kill it
class CmdRemoteDetach : public Command {
protected:
  int id;			// which molecule to detach (ID of molecule)
  virtual int do_execute(void);
public:
  CmdRemoteDetach(int, int=(-1));
};


/////////////// kill a running simulation
class CmdRemoteKill : public Command {
protected:
  int id;			// which molecule to kill (ID of molecule)
  virtual int do_execute(void);
public:
  CmdRemoteKill(int, int=(-1));
};


/////////////// list all current and previous simulations
class CmdRemoteSimList : public Command {
protected:
  virtual int do_execute(void);
public:
  CmdRemoteSimList(int=(-1));
};


#endif
