/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/03/24 18:48:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdRender.C,v $
Revision 1.1  95/03/24  18:48:05  billh
Initial revision

 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdRender.C,v 1.1 95/03/24 18:48:05 billh Exp $";
#endif

#include "CmdRender.h"
#include "Scene.h"
#include "DisplayDevice.h"
#include "Global.h"
#include "utilities.h"

///////////////////////// render the global scene
CmdRender::CmdRender(char *newmethod, char *newfilename, int id)
	: Command(Command::RENDER, id) {
  sc = scene;           // get the global scene
  display = ::display;  // ditto for disp. dev.
  filename = stringdup(newfilename);
  method = stringdup(newmethod);
  
  // make the text needed for the log output
  *cmdText << "render " << newmethod << " " << newfilename << ends;
}

CmdRender::~CmdRender(void) {
  delete [] filename;
  delete [] method;
}

int CmdRender::do_execute(void) {
  return sc -> filedraw(method, filename, display);
}


/////////////////////// list the available rendering types
CmdRenderList::CmdRenderList(int id) : Command(Command::RENDERLIST, id) {
  *cmdText << "render list" << ends;
}

int CmdRenderList::do_execute(void) {
//   if (fileRenderList.num() == 0) {
     msgInfo << "There are currently no possible output formats." << sendmsg;
//   } else {
//     msgInfo << "The valid image output formats are:" << sendmsg;
//     for (int i=0; i<fileRenderList.num(); i++) {
//       msgInfo << i+1 << "  " << renderList.name(i) << sendmsg;
//     }
//   }

   return TRUE;
}
